/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaMotivoDesoneracaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoDeducaoIcms;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS70
extends DFBase {
    private static final long serialVersionUID = -5946992423885910972L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="modBC")
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="pRedBC")
    private String percentualReducaoBC;
    @Element(name="vBC")
    private String valorBC;
    @Element(name="pICMS")
    private String percentualAliquota;
    @Element(name="vICMS")
    private String valorTributo;
    @Element(name="vBCFCP", required=false)
    private String valorBCFundoCombatePobreza;
    @Element(name="pFCP", required=false)
    private String percentualFundoCombatePobreza;
    @Element(name="vFCP", required=false)
    private String valorFundoCombatePobreza;
    @Element(name="modBCST")
    private NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST;
    @Element(name="pMVAST", required=false)
    private String percentualMargemValorAdicionadoICMSST;
    @Element(name="pRedBCST", required=false)
    private String percentualReducaoBCICMSST;
    @Element(name="vBCST")
    private String valorBCST;
    @Element(name="pICMSST")
    private String percentualAliquotaImpostoICMSST;
    @Element(name="vICMSST")
    private String valorICMSST;
    @Element(name="vBCFCPST", required=false)
    private String valorBCFundoCombatePobrezaST;
    @Element(name="pFCPST", required=false)
    private String percentualFundoCombatePobrezaST;
    @Element(name="vFCPST", required=false)
    private String valorFundoCombatePobrezaST;
    @Element(name="vICMSDeson", required=false)
    private String valorICMSDesoneracao;
    @Element(name="motDesICMS", required=false)
    private NFNotaMotivoDesoneracaoICMS desoneracao;
    @Element(name="vICMSSTDeson", required=false)
    private String valorICMSSTDesonerado;
    @Element(name="motDesICMSST", required=false)
    private NFNotaMotivoDesoneracaoICMS motivoDesoneracaoICMSST;
    @Element(name="indDeduzDeson", required=false)
    private NFTipoDeducaoIcms indicaDeduzDesoneracao;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS nFNotaInfoItemModalidadeBCICMS) {
        this.modalidadeBCICMS = nFNotaInfoItemModalidadeBCICMS;
    }

    public void setPercentualReducaoBC(BigDecimal bigDecimal) {
        this.percentualReducaoBC = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS70 Item");
    }

    public void setValorBC(BigDecimal bigDecimal) {
        this.valorBC = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS70 Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota ICMS70 Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo ICMS70 Item");
    }

    public void setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST) {
        this.modalidadeBCICMSST = nFNotaInfoItemModalidadeBCICMSST;
    }

    public void setPercentualMargemValorAdicionadoICMSST(BigDecimal bigDecimal) {
        this.percentualMargemValorAdicionadoICMSST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Margem Valor Adicionado ICMS ST ICMS70 Item");
    }

    public void setPercentualReducaoBCICMSST(BigDecimal bigDecimal) {
        this.percentualReducaoBCICMSST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS ST ICMS70 Item");
    }

    public void setValorBCST(BigDecimal bigDecimal) {
        this.valorBCST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ST ICMS70 Item");
    }

    public void setPercentualAliquotaImpostoICMSST(BigDecimal bigDecimal) {
        this.percentualAliquotaImpostoICMSST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Imposto ICMS ST ICMS70 Item");
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST ICMS70 Item");
    }

    public void setDesoneracao(NFNotaMotivoDesoneracaoICMS nFNotaMotivoDesoneracaoICMS) {
        this.desoneracao = nFNotaMotivoDesoneracaoICMS;
    }

    public void setValorICMSDesoneracao(BigDecimal bigDecimal) {
        this.valorICMSDesoneracao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Desoneracao ICMS70 Item");
    }

    public void setValorBCFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor base calculo fundo combate pobreza");
    }

    public void setPercentualFundoCombatePobreza(BigDecimal bigDecimal) {
        if (bigDecimal.signum() <= 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobreza = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza");
    }

    public void setValorFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza");
    }

    public void setValorBCFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobrezaST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base calculo fundo combate pobreza ST");
    }

    public void setPercentualFundoCombatePobrezaST(BigDecimal bigDecimal) {
        if (bigDecimal.signum() <= 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobrezaST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza ST");
    }

    public void setValorFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorFundoCombatePobrezaST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza ST");
    }

    public void setValorICMSSTDesonerado(BigDecimal bigDecimal) {
        this.valorICMSSTDesonerado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor do ICMS-ST desonerado");
    }

    public void setMotivoDesoneracaoICMSST(NFNotaMotivoDesoneracaoICMS nFNotaMotivoDesoneracaoICMS) {
        this.motivoDesoneracaoICMSST = nFNotaMotivoDesoneracaoICMS;
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getPercentualReducaoBC() {
        return this.percentualReducaoBC;
    }

    public String getValorBC() {
        return this.valorBC;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }

    public NFNotaInfoItemModalidadeBCICMSST getModalidadeBCICMSST() {
        return this.modalidadeBCICMSST;
    }

    public String getPercentualMargemValorAdicionadoICMSST() {
        return this.percentualMargemValorAdicionadoICMSST;
    }

    public String getPercentualReducaoBCICMSST() {
        return this.percentualReducaoBCICMSST;
    }

    public String getValorBCST() {
        return this.valorBCST;
    }

    public String getPercentualAliquotaImpostoICMSST() {
        return this.percentualAliquotaImpostoICMSST;
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public String getValorICMSDesoneracao() {
        return this.valorICMSDesoneracao;
    }

    public NFNotaMotivoDesoneracaoICMS getDesoneracao() {
        return this.desoneracao;
    }

    public String getValorBCFundoCombatePobreza() {
        return this.valorBCFundoCombatePobreza;
    }

    public String getPercentualFundoCombatePobreza() {
        return this.percentualFundoCombatePobreza;
    }

    public String getValorFundoCombatePobreza() {
        return this.valorFundoCombatePobreza;
    }

    public String getPercentualFundoCombatePobrezaST() {
        return this.percentualFundoCombatePobrezaST;
    }

    public String getValorBCFundoCombatePobrezaST() {
        return this.valorBCFundoCombatePobrezaST;
    }

    public String getValorFundoCombatePobrezaST() {
        return this.valorFundoCombatePobrezaST;
    }

    public String getValorICMSSTDesonerado() {
        return this.valorICMSSTDesonerado;
    }

    public NFNotaMotivoDesoneracaoICMS getMotivoDesoneracaoICMSST() {
        return this.motivoDesoneracaoICMSST;
    }

    public NFTipoDeducaoIcms getIndicaDeduzDesoneracao() {
        return this.indicaDeduzDesoneracao;
    }

    public void setIndicaDeduzDesoneracao(NFTipoDeducaoIcms nFTipoDeducaoIcms) {
        this.indicaDeduzDesoneracao = nFTipoDeducaoIcms;
    }
}

