/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemIndicadorExigibilidadeISS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemIndicadorIncentivoFiscal;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoISSQN
extends DFBase {
    private static final long serialVersionUID = 5303195667632685433L;
    @Element(name="vBC")
    private String valorBaseCalculo;
    @Element(name="vAliq")
    private String valorAliquota;
    @Element(name="vISSQN")
    private String valor;
    @Element(name="cMunFG")
    private Integer codigoMunicipio;
    @Element(name="cListServ")
    private String itemListaServicos;
    @Element(name="vDeducao", required=false)
    private String valorDeducao;
    @Element(name="vOutro", required=false)
    private String valorOutro;
    @Element(name="vDescIncond", required=false)
    private String valorDescontoIncondicionado;
    @Element(name="vDescCond", required=false)
    private String valorDescontoCondicionado;
    @Element(name="vISSRet", required=false)
    private String valorRetencaoISS;
    @Element(name="indISS")
    private NFNotaInfoItemIndicadorExigibilidadeISS indicadorExigibilidadeISS;
    @Element(name="cServico", required=false)
    private String codigoServico;
    @Element(name="cMun", required=false)
    private String codigoMunicipioIncidenciaImposto;
    @Element(name="cPais", required=false)
    private String codigoPais;
    @Element(name="nProcesso", required=false)
    private String numeroProcesso;
    @Element(name="indIncentivo")
    private NFNotaInfoItemIndicadorIncentivoFiscal indicadorIncentivoFiscal;

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        this.valorBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ISSQN Item");
    }

    public void setValorAliquota(BigDecimal bigDecimal) {
        this.valorAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Valor Aliquota ISSQN Item");
    }

    public void setValor(BigDecimal bigDecimal) {
        this.valor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ISSQN Item");
    }

    public void setCodigoMunicipio(Integer n) {
        DFIntegerValidador.exatamente7(n, "Codigo Municipio ISSQN Item");
        this.codigoMunicipio = n;
    }

    public void setItemListaServicos(String string) {
        DFStringValidador.itemListaServico(string);
        this.itemListaServicos = string;
    }

    public void setCodigoMunicipioIncidenciaImposto(String string) {
        DFStringValidador.exatamente7N(string, "Codigo Municipio Incidencia Imposto ISSQN Item");
        this.codigoMunicipioIncidenciaImposto = string;
    }

    public void setCodigoPais(String string) {
        DFStringValidador.exatamente4N(string, "Codigo Pais ISSQN Item");
        this.codigoPais = string;
    }

    public void setCodigoServico(String string) {
        DFStringValidador.tamanho20(string, "Codigo Servico ISSQN Item");
        this.codigoServico = string;
    }

    public void setIndicadorExigibilidadeISS(NFNotaInfoItemIndicadorExigibilidadeISS nFNotaInfoItemIndicadorExigibilidadeISS) {
        this.indicadorExigibilidadeISS = nFNotaInfoItemIndicadorExigibilidadeISS;
    }

    public void setIndicadorIncentivoFiscal(NFNotaInfoItemIndicadorIncentivoFiscal nFNotaInfoItemIndicadorIncentivoFiscal) {
        this.indicadorIncentivoFiscal = nFNotaInfoItemIndicadorIncentivoFiscal;
    }

    public void setNumeroProcesso(String string) {
        DFStringValidador.tamanho30(string, "Numero Processo ISSQN Item");
        this.numeroProcesso = string;
    }

    public void setValorDeducao(BigDecimal bigDecimal) {
        this.valorDeducao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Deducao ISSQN Item");
    }

    public void setValorDescontoCondicionado(BigDecimal bigDecimal) {
        this.valorDescontoCondicionado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Desconto Condicionado ISSQN Item");
    }

    public void setValorDescontoIncondicionado(BigDecimal bigDecimal) {
        this.valorDescontoIncondicionado = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Desconto Incondicionado ISSQN Item");
    }

    public void setValorOutro(BigDecimal bigDecimal) {
        this.valorOutro = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Outro ISSQN Item");
    }

    public void setValorRetencaoISS(BigDecimal bigDecimal) {
        this.valorRetencaoISS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Retencao ISS ISSQN Item");
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValor() {
        return this.valor;
    }

    public Integer getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public String getItemListaServicos() {
        return this.itemListaServicos;
    }

    public String getValorDeducao() {
        return this.valorDeducao;
    }

    public String getValorOutro() {
        return this.valorOutro;
    }

    public String getValorDescontoIncondicionado() {
        return this.valorDescontoIncondicionado;
    }

    public String getValorDescontoCondicionado() {
        return this.valorDescontoCondicionado;
    }

    public String getValorRetencaoISS() {
        return this.valorRetencaoISS;
    }

    public NFNotaInfoItemIndicadorExigibilidadeISS getIndicadorExigibilidadeISS() {
        return this.indicadorExigibilidadeISS;
    }

    public String getCodigoServico() {
        return this.codigoServico;
    }

    public String getCodigoMunicipioIncidenciaImposto() {
        return this.codigoMunicipioIncidenciaImposto;
    }

    public String getCodigoPais() {
        return this.codigoPais;
    }

    public String getNumeroProcesso() {
        return this.numeroProcesso;
    }

    public NFNotaInfoItemIndicadorIncentivoFiscal getIndicadorIncentivoFiscal() {
        return this.indicadorIncentivoFiscal;
    }
}

