/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFDetCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;

@Namespace(reference="http://www.portalfiscal.inf.br/nfe")
public class NFInfCancelamentoComprovanteEntrega
extends DFBase {
    private static final long serialVersionUID = 6539156445828933675L;
    public static final String IDENT = "infEvento";
    @Attribute(name="Id")
    private String id;
    @Element(name="cOrgao")
    private DFUnidadeFederativa orgao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="chNFe")
    private String chaveAcessoNFe;
    @Element(name="dhEvento")
    private ZonedDateTime dataEvento;
    @Element(name="tpEvento")
    private String tipoEvento;
    @Element(name="nSeqEvento")
    private Integer numSeqEvento;
    @Element(name="verEvento")
    private String verEvento;
    @Element(name="detEvento", required=true)
    private NFDetCancelamentoComprovanteEntrega detalhesEvento;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        DFStringValidador.exatamente54(string, "Info Evento ID");
        this.id = string;
    }

    public DFUnidadeFederativa getOrgao() {
        return this.orgao;
    }

    public void setOrgao(DFUnidadeFederativa dFUnidadeFederativa) {
        this.orgao = dFUnidadeFederativa;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("CPF ja foi setado");
        }
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("CNPJ ja foi setado");
        }
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getChaveAcessoNFe() {
        return this.chaveAcessoNFe;
    }

    public void setChaveAcessoNFe(String string) {
        DFStringValidador.exatamente44N(string, "Info Evento Chave");
        this.chaveAcessoNFe = string;
    }

    public ZonedDateTime getDataEvento() {
        return this.dataEvento;
    }

    public void setDataEvento(ZonedDateTime zonedDateTime) {
        this.dataEvento = zonedDateTime;
    }

    public String getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(String string) {
        DFStringValidador.exatamente6N(string, "Tipo Evento");
        this.tipoEvento = string;
    }

    public Integer getNumSeqEvento() {
        return this.numSeqEvento;
    }

    public void setNumSeqEvento(Integer n) {
        DFIntegerValidador.tamanho1a2(n, "Numero Sequencial Evento");
        this.numSeqEvento = n;
    }

    public String getVerEvento() {
        return this.verEvento;
    }

    public void setVerEvento(BigDecimal bigDecimal) {
        this.verEvento = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Info Evento Versao");
    }

    public NFDetCancelamentoComprovanteEntrega getDetalhesEvento() {
        return this.detalhesEvento;
    }

    public void setDetalhesEvento(NFDetCancelamentoComprovanteEntrega nFDetCancelamentoComprovanteEntrega) {
        this.detalhesEvento = nFDetCancelamentoComprovanteEntrega;
    }
}

