/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices.comprovanteentrega;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.cancelamento.NFEnvCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoEvtComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.webservices.comprovanteentrega.WSBaseComprovanteEntrega;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.axiom.om.OMElement;

public class WSCancelamentoEvtComprovanteEntrega
extends WSBaseComprovanteEntrega {
    private static final String EVENTO_CODIGO = "110131";

    public WSCancelamentoEvtComprovanteEntrega(NFeConfig nFeConfig) {
        super(nFeConfig);
    }

    public NFRetornoEvtComprovanteEntrega cancelarComprovante(String string, NFEnvCancelamentoComprovanteEntrega nFEnvCancelamentoComprovanteEntrega, int n) throws Exception {
        String string2 = this.getXmlAssinado(string, nFEnvCancelamentoComprovanteEntrega, n);
        OMElement oMElement = this.efetuaEnvio(string2);
        return (NFRetornoEvtComprovanteEntrega)this.getConfig().getPersister().read(NFRetornoEvtComprovanteEntrega.class, oMElement.toString());
    }

    public String getXmlAssinado(String string, NFEnvCancelamentoComprovanteEntrega nFEnvCancelamentoComprovanteEntrega, int n) throws Exception {
        String string2 = this.complementarDadosEvento(string, nFEnvCancelamentoComprovanteEntrega, n).toString();
        return this.assinarDocumento(string2);
    }

    public NFEnvCancelamentoComprovanteEntrega complementarDadosEvento(String string, NFEnvCancelamentoComprovanteEntrega nFEnvCancelamentoComprovanteEntrega, int n) {
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        nFEnvCancelamentoComprovanteEntrega.setVersao(this.getVersao().toString());
        nFEnvCancelamentoComprovanteEntrega.setIdLote("1");
        List<NFCancelamentoComprovanteEntrega> list = nFEnvCancelamentoComprovanteEntrega.getEvento();
        if (list != null) {
            for (NFCancelamentoComprovanteEntrega nFCancelamentoComprovanteEntrega : list) {
                nFCancelamentoComprovanteEntrega.setVersao(this.getVersao());
                if (nFCancelamentoComprovanteEntrega.getInfEvento() == null) continue;
                nFCancelamentoComprovanteEntrega.getInfEvento().setAmbiente(this.getConfig().getAmbiente());
                nFCancelamentoComprovanteEntrega.getInfEvento().setChaveAcessoNFe(string);
                if (Integer.parseInt(notaFiscalChaveParser.getSerie()) >= 920 && Integer.parseInt(notaFiscalChaveParser.getSerie()) <= 969) {
                    nFCancelamentoComprovanteEntrega.getInfEvento().setCpf(notaFiscalChaveParser.getCpfEmitente());
                } else {
                    nFCancelamentoComprovanteEntrega.getInfEvento().setCnpj(notaFiscalChaveParser.getCnpjEmitente());
                }
                nFCancelamentoComprovanteEntrega.getInfEvento().setDataEvento(ZonedDateTime.now(this.getConfig().getTimeZone().toZoneId()));
                nFCancelamentoComprovanteEntrega.getInfEvento().setId(String.format("ID%s%s%02d", EVENTO_CODIGO, string, n));
                nFCancelamentoComprovanteEntrega.getInfEvento().setNumSeqEvento(n);
                nFCancelamentoComprovanteEntrega.getInfEvento().setOrgao(DFUnidadeFederativa.RFB);
                nFCancelamentoComprovanteEntrega.getInfEvento().setTipoEvento(EVENTO_CODIGO);
                nFCancelamentoComprovanteEntrega.getInfEvento().setVerEvento(this.getVersao());
                nFCancelamentoComprovanteEntrega.getInfEvento().getDetalhesEvento().setVersao(this.getVersao());
            }
        }
        return nFEnvCancelamentoComprovanteEntrega;
    }
}

