/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import kong.unirest.BasicResponse;
import kong.unirest.Config;
import kong.unirest.Cookies;
import kong.unirest.Headers;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.RawResponse;
import kong.unirest.UnirestParsingException;

abstract class BaseResponse<T>
implements HttpResponse<T> {
    private final Headers headers;
    private final String statusText;
    private final int statusCode;
    private Optional<UnirestParsingException> parsingerror = Optional.empty();
    private final Config config;
    private Cookies cookies;
    private final HttpRequestSummary requestSummary;

    protected BaseResponse(RawResponse response) {
        this.headers = response.getHeaders();
        this.headers.remove("Content-Encoding", "gzip");
        this.statusCode = response.getStatus();
        this.statusText = response.getStatusText();
        this.config = response.getConfig();
        this.requestSummary = response.getRequestSummary();
    }

    protected BaseResponse(BaseResponse other) {
        this.headers = other.headers;
        this.statusCode = other.statusCode;
        this.statusText = other.statusText;
        this.config = other.config;
        this.requestSummary = other.requestSummary;
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public abstract T getBody();

    @Override
    public Optional<UnirestParsingException> getParsingError() {
        return this.parsingerror;
    }

    @Override
    public <V> V mapBody(Function<T, V> func) {
        return func.apply(this.getBody());
    }

    @Override
    public <V> HttpResponse<V> map(Function<T, V> func) {
        return new BasicResponse<V>(this, this.mapBody(func));
    }

    protected void setParsingException(String originalBody, RuntimeException e) {
        this.parsingerror = Optional.of(new UnirestParsingException(originalBody, e));
    }

    @Override
    public boolean isSuccess() {
        return this.getStatus() >= 200 && this.getStatus() < 300 && !this.getParsingError().isPresent();
    }

    @Override
    public HttpResponse<T> ifSuccess(Consumer<HttpResponse<T>> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public HttpResponse<T> ifFailure(Consumer<HttpResponse<T>> consumer) {
        if (!this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public <E> E mapError(Class<? extends E> errorClass) {
        if (!this.isSuccess()) {
            String errorBody = this.getErrorBody();
            if (String.class.equals(errorClass)) {
                return (E)errorBody;
            }
            try {
                return this.config.getObjectMapper().readValue(errorBody, errorClass);
            }
            catch (RuntimeException e) {
                this.setParsingException(errorBody, e);
            }
        }
        return null;
    }

    private String getErrorBody() {
        if (this.getParsingError().isPresent()) {
            return this.getParsingError().get().getOriginalBody();
        }
        if (this.getRawBody() != null) {
            return this.getRawBody();
        }
        T body = this.getBody();
        if (body == null) {
            return null;
        }
        try {
            if (body instanceof byte[]) {
                return new String((byte[])body, StandardCharsets.UTF_8);
            }
            return this.config.getObjectMapper().writeValue(body);
        }
        catch (Exception e) {
            return String.valueOf(body);
        }
    }

    @Override
    public <E> HttpResponse<T> ifFailure(Class<? extends E> errorClass, Consumer<HttpResponse<E>> consumer) {
        if (!this.isSuccess()) {
            E error = this.mapError(errorClass);
            BasicResponse br = new BasicResponse(this, error);
            this.getParsingError().ifPresent(p -> br.setParsingException(p.getOriginalBody(), (RuntimeException)p));
            consumer.accept(br);
        }
        return this;
    }

    @Override
    public Cookies getCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies(this.headers.get("set-cookie"));
        }
        return this.cookies;
    }

    @Override
    public HttpRequestSummary getRequestSummary() {
        return this.requestSummary;
    }

    protected abstract String getRawBody();
}

