/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.TimeZone;
import org.simpleframework.xml.core.Persister;

public abstract class DFConfig {
    public static final TimeZone TIMEZONE_SP = TimeZone.getTimeZone("America/Sao_Paulo");
    private Persister persister;

    public DFAmbiente getAmbiente() {
        return DFAmbiente.HOMOLOGACAO;
    }

    public DFModelo getModelo() {
        return DFModelo.NFE;
    }

    public abstract DFUnidadeFederativa getCUF();

    public abstract KeyStore getCertificadoKeyStore() throws KeyStoreException;

    public String getCertificadoAlias() {
        return null;
    }

    public abstract String getCertificadoSenha();

    public abstract KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException;

    public abstract String getCadeiaCertificadosSenha();

    public String[] getSSLProtocolos() {
        return new String[]{"TLSv1.2"};
    }

    public int getTimeoutRequisicaoEmMillis() {
        return 60000;
    }

    public int getSoTimeoutEmMillis() {
        return 30000;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Persister getPersister() {
        if (this.persister == null) {
            this.persister = new DFPersister();
        }
        return this.persister;
    }

    public String getCSRT() {
        return "";
    }
}

