/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte.webservices.distribuicao;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoConsultaNSU;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoInt;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoNSU;
import com.fincatto.documentofiscal.cte.webservices.distribuicao.CTeDistribuicaoDFeSoapStub;
import com.fincatto.documentofiscal.cte200.classes.CTAutorizador;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang3.StringUtils;

public class WSDistribuicaoCTe {
    private final CTeConfig config;

    public WSDistribuicaoCTe(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    @Deprecated
    public static String consultar(CTDistribuicaoInt cTDistribuicaoInt, NFeConfig nFeConfig) throws Exception {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(nFeConfig), 443));
        try {
            OMElement oMElement = AXIOMUtil.stringToOM((String)cTDistribuicaoInt.toString());
            CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0 cteDadosMsg_type0 = new CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0();
            cteDadosMsg_type0.setExtraElement(oMElement);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse cteDistDFeInteresse = new CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse();
            cteDistDFeInteresse.setCteDadosMsg(cteDadosMsg_type0);
            CTeDistribuicaoDFeSoapStub cTeDistribuicaoDFeSoapStub = new CTeDistribuicaoDFeSoapStub(CTAutorizador.AN.getDistribuicaoDFe(nFeConfig.getAmbiente()), nFeConfig);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresseResponse cteDistDFeInteresseResponse = cTeDistribuicaoDFeSoapStub.cteDistDFeInteresse(cteDistDFeInteresse);
            return cteDistDFeInteresseResponse.getCteDistDFeInteresseResult().getExtraElement().toString();
        }
        catch (RemoteException | XMLStreamException exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public CTDistribuicaoIntRetorno consultar(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3) throws Exception {
        try {
            String string4 = this.gerarCTeDistribuicaoInt(string, dFUnidadeFederativa, string2, string3).toString();
            DFXMLValidador.validaDistribuicaoCTe(string4);
            OMElement oMElement = AXIOMUtil.stringToOM((String)string4);
            CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0 cteDadosMsg_type0 = new CTeDistribuicaoDFeSoapStub.CteDadosMsg_type0();
            cteDadosMsg_type0.setExtraElement(oMElement);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse cteDistDFeInteresse = new CTeDistribuicaoDFeSoapStub.CteDistDFeInteresse();
            cteDistDFeInteresse.setCteDadosMsg(cteDadosMsg_type0);
            CTeDistribuicaoDFeSoapStub cTeDistribuicaoDFeSoapStub = new CTeDistribuicaoDFeSoapStub(CTAutorizador.AN.getDistribuicaoDFe(this.config.getAmbiente()), this.config);
            CTeDistribuicaoDFeSoapStub.CteDistDFeInteresseResponse cteDistDFeInteresseResponse = cTeDistribuicaoDFeSoapStub.cteDistDFeInteresse(cteDistDFeInteresse);
            return (CTDistribuicaoIntRetorno)this.config.getPersister().read(CTDistribuicaoIntRetorno.class, cteDistDFeInteresseResponse.getCteDistDFeInteresseResult().getExtraElement().toString());
        }
        catch (RemoteException | XMLStreamException exception) {
            throw new Exception(exception.getMessage());
        }
    }

    private CTDistribuicaoInt gerarCTeDistribuicaoInt(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3) {
        CTDistribuicaoInt cTDistribuicaoInt = new CTDistribuicaoInt();
        cTDistribuicaoInt.setVersao("1.00");
        cTDistribuicaoInt.setAmbiente(this.config.getAmbiente());
        cTDistribuicaoInt.setUnidadeFederativaAutor(dFUnidadeFederativa);
        if (string.length() == 11) {
            cTDistribuicaoInt.setCpf(string);
        } else {
            cTDistribuicaoInt.setCnpj(string);
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            cTDistribuicaoInt.setDistribuicao(new CTDistribuicaoNSU().setUltimoNSU(string3));
        } else {
            cTDistribuicaoInt.setConsulta(new CTDistribuicaoConsultaNSU().setNsu(string2));
        }
        return cTDistribuicaoInt;
    }

    public static String decodeGZipToXml(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return "";
        }
        byte[] byArray = Base64.getDecoder().decode(string);
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));){
            String string2;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gZIPInputStream, StandardCharsets.UTF_8));){
                String string3;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
                string2 = stringBuilder.toString();
            }
            return string2;
        }
    }
}

