/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.evento;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeDetalhamentoEvento;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class CTeInfoEvento
extends DFBase {
    private static final long serialVersionUID = 4495040029270775685L;
    @Attribute(name="Id", required=false)
    private String id;
    @Element(name="cOrgao", required=false)
    private DFUnidadeFederativa orgao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="chCTe")
    private String chave;
    @Element(name="dhEvento")
    private ZonedDateTime dataHoraEvento;
    @Element(name="tpEvento")
    private String codigoEvento;
    @Element(name="nSeqEvento")
    private Integer numeroSequencialEvento;
    @Element(name="detEvento")
    private CTeDetalhamentoEvento detalheEvento;

    public void setOrgao(DFUnidadeFederativa dFUnidadeFederativa) {
        this.orgao = dFUnidadeFederativa;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        DFStringValidador.exatamente54(string, "Info Evento ID");
        this.id = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("CPF ja foi setado");
        }
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("CNPJ ja foi setado");
        }
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        DFStringValidador.exatamente44N(string, "Info Evento Chave");
        this.chave = string;
    }

    public ZonedDateTime getDataHoraEvento() {
        return this.dataHoraEvento;
    }

    public void setDataHoraEvento(ZonedDateTime zonedDateTime) {
        this.dataHoraEvento = zonedDateTime;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String string) {
        DFStringValidador.exatamente6N(string, "Info Evento Codigo");
        this.codigoEvento = string;
    }

    public int getNumeroSequencialEvento() {
        return this.numeroSequencialEvento;
    }

    public void setNumeroSequencialEvento(int n) {
        DFIntegerValidador.tamanho1a2(n, "Numero Sequencial Evento");
        this.numeroSequencialEvento = n;
    }

    public DFUnidadeFederativa getOrgao() {
        return this.orgao;
    }

    public void setNumeroSequencialEvento(Integer n) {
        this.numeroSequencialEvento = n;
    }

    public CTeDetalhamentoEvento getDetalheEvento() {
        return this.detalheEvento;
    }

    public void setDetalheEvento(CTeDetalhamentoEvento cTeDetalhamentoEvento) {
        this.detalheEvento = cTeDetalhamentoEvento;
    }
}

