/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.evento.comprovanteentrega;

import com.fincatto.documentofiscal.cte300.classes.evento.CTeTipoEvento;
import com.fincatto.documentofiscal.cte300.classes.evento.comprovanteentrega.CTeInformacaoComprovanteEntrega;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.ZonedDateTime;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="evCECTe")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeEnviaEventoComprovanteEntrega
extends CTeTipoEvento {
    private static final long serialVersionUID = -5488904753372508623L;
    @Element(name="nProt")
    private String protocoloAutorizacao;
    @Element(name="dhEntrega")
    private ZonedDateTime dataHoraEntrega;
    @Element(name="nDoc")
    private String documentoRecebedor;
    @Element(name="xNome")
    private String nomeRecebedor;
    @Element(name="latitude", required=false)
    private String latitude;
    @Element(name="longitude", required=false)
    private String longitude;
    @Element(name="hashEntrega")
    private String hashEntrega;
    @Element(name="dhHashEntrega")
    private ZonedDateTime dataHoraHashEntrega;
    @ElementList(inline=true, required=false)
    private List<CTeInformacaoComprovanteEntrega> entregas;

    public String getProtocoloAutorizacao() {
        return this.protocoloAutorizacao;
    }

    public void setProtocoloAutorizacao(String string) {
        DFStringValidador.exatamente15N(string, "Protocolo de Autorizacao");
        this.protocoloAutorizacao = string;
    }

    public ZonedDateTime getDataHoraEntrega() {
        return this.dataHoraEntrega;
    }

    public void setDataHoraEntrega(ZonedDateTime zonedDateTime) {
        this.dataHoraEntrega = zonedDateTime;
    }

    public String getDocumentoRecebedor() {
        return this.documentoRecebedor;
    }

    public void setDocumentoRecebedor(String string) {
        DFStringValidador.tamanho20(string, "Documento Recebedor");
        this.documentoRecebedor = string;
    }

    public String getNomeRecebedor() {
        return this.nomeRecebedor;
    }

    public void setNomeRecebedor(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome Recebedor");
        this.nomeRecebedor = string;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String string) {
        this.latitude = string;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String string) {
        this.longitude = string;
    }

    public String getHashEntrega() {
        return this.hashEntrega;
    }

    public void setHashEntrega(String string) {
        this.hashEntrega = string;
    }

    public ZonedDateTime getDataHoraHashEntrega() {
        return this.dataHoraHashEntrega;
    }

    public void setDataHoraHashEntrega(ZonedDateTime zonedDateTime) {
        this.dataHoraHashEntrega = zonedDateTime;
    }

    public List<CTeInformacaoComprovanteEntrega> getEntregas() {
        return this.entregas;
    }

    public void setEntregas(List<CTeInformacaoComprovanteEntrega> list) {
        this.entregas = list;
    }
}

