/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFPais;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;

public class CTeNotaEndereco
extends DFBase {
    private static final long serialVersionUID = 1528514404620728196L;
    @Element(name="xLgr")
    private String logradouro = null;
    @Element(name="nro")
    private String numero = null;
    @Element(name="xCpl", required=false)
    private String complemento = null;
    @Element(name="xBairro")
    private String bairro = null;
    @Element(name="cMun")
    private String codigoMunicipio = null;
    @Element(name="xMun")
    private String descricaoMunicipio = null;
    @Element(name="CEP", required=false)
    private String cep = null;
    @Element(name="UF")
    private String siglaUF = null;
    @Element(name="cPais", required=false)
    private DFPais codigoPais = null;
    @Element(name="xPais", required=false)
    private String descricaoPais = null;

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String string) {
        DFStringValidador.tamanho2ate60(string, "Logradouro");
        this.logradouro = string;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String string) {
        DFStringValidador.tamanho60(string, "N\u00famero");
        this.numero = string;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String string) {
        DFStringValidador.tamanho60(string, "Complemento");
        this.complemento = string;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String string) {
        DFStringValidador.tamanho2ate60(string, "Bairro");
        this.bairro = string;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public void setCodigoMunicipio(String string) {
        DFStringValidador.exatamente7N(string, "C\u00f3digo do munic\u00edpio");
        this.codigoMunicipio = string;
    }

    public String getDescricaoMunicipio() {
        return this.descricaoMunicipio;
    }

    public void setDescricaoMunicipio(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome do munic\u00edpio");
        this.descricaoMunicipio = string;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String string) {
        DFStringValidador.exatamente8N(string, "CEP");
        this.cep = string;
    }

    public String getSiglaUF() {
        return this.siglaUF;
    }

    public void setSiglaUF(String string) {
        DFStringValidador.exatamente2(string, "Sigla da UF");
        this.siglaUF = string;
    }

    public DFPais getCodigoPais() {
        return this.codigoPais;
    }

    public void setCodigoPais(String string) {
        DFStringValidador.tamanho4N(string, "C\u00f3digo do pa\u00eds");
        this.codigoPais = DFPais.valueOfCodigo(string);
    }

    public String getDescricaoPais() {
        return this.descricaoPais;
    }

    public void setDescricaoPais(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome do pa\u00eds");
        this.descricaoPais = string;
    }
}

