/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="rem")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoRemetente
extends DFBase {
    private static final long serialVersionUID = -6678523041232814382L;
    @Element(name="CNPJ", required=false)
    private String cnpj = null;
    @Element(name="CPF", required=false)
    private String cpf = null;
    @Element(name="IE", required=false)
    private String inscricaoEstadual = null;
    @Element(name="xNome")
    private String razaoSocial = null;
    @Element(name="xFant", required=false)
    private String nomeFantasia = null;
    @Element(name="fone", required=false)
    private String telefone = null;
    @Element(name="enderReme")
    private CTeNotaEndereco endereco = null;
    @Element(name="email", required=false)
    private String email = null;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        DFStringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        DFStringValidador.tamanho2ate60(string, "Raz\u00e3o social ou nome do remetente");
        this.razaoSocial = string;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome fantasia");
        this.nomeFantasia = string;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String string) {
        DFStringValidador.telefone(string);
        this.telefone = string;
    }

    public CTeNotaEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(CTeNotaEndereco cTeNotaEndereco) {
        this.endereco = cTeNotaEndereco;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        DFStringValidador.tamanho60(string, "Endere\u00e7o de email");
        DFStringValidador.email(string);
        this.email = string;
    }
}

