/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.utils;

import com.fincatto.documentofiscal.cte.CTTipoEmissao;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte300.classes.os.CTeOS;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;

public class CTeGeraQRCode {
    private final CTeConfig config;

    public CTeGeraQRCode(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    private String getQRCode(String string) throws Exception {
        String string2 = CTAutorizador31.valueOfChaveAcesso(string).getCteQrCode(this.config.getAmbiente());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("chCTe=").append(string).append("&");
        stringBuilder.append("tpAmb=").append(this.config.getAmbiente().getCodigo());
        if (this.config.getTipoEmissao().equals((Object)CTTipoEmissao.CONTINGENCIA_EPEC)) {
            stringBuilder.append("&sign=").append(new DFAssinaturaDigital(this.config).assinarString(string));
        }
        return string2 + "?" + stringBuilder.toString();
    }

    public String getQRCode(CTeNota cTeNota) throws Exception {
        return this.getQRCode(cTeNota.getCteNotaInfo().getChaveAcesso());
    }

    public String getQRCode(CTeOS cTeOS) throws Exception {
        return this.getQRCode(cTeOS.getInfo().getChaveAcesso());
    }
}

