/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte.classes.distribuicao.CTDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.cte.webservices.distribuicao.WSDistribuicaoCTe;
import com.fincatto.documentofiscal.cte300.classes.consultastatusservico.CTeConsStatServRet;
import com.fincatto.documentofiscal.cte300.classes.envio.CTeOSEnvioRetornoDados;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLote;
import com.fincatto.documentofiscal.cte300.classes.enviolote.CTeEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.cte300.classes.enviolote.consulta.CTeConsultaRecLoteRet;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte300.classes.evento.cartacorrecao.CTeInformacaoCartaCorrecao;
import com.fincatto.documentofiscal.cte300.classes.evento.comprovanteentrega.CTeEnviaEventoComprovanteEntrega;
import com.fincatto.documentofiscal.cte300.classes.evento.epec.CTeEnviaEventoEpec;
import com.fincatto.documentofiscal.cte300.classes.evento.gtv.CTeEnviaEventoGtv;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTeRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.cte300.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte300.classes.os.CTeOS;
import com.fincatto.documentofiscal.cte300.webservices.WSCancelamento;
import com.fincatto.documentofiscal.cte300.webservices.WSCancelamentoComprovanteEntrega;
import com.fincatto.documentofiscal.cte300.webservices.WSCartaCorrecao;
import com.fincatto.documentofiscal.cte300.webservices.WSComprovanteEntrega;
import com.fincatto.documentofiscal.cte300.webservices.WSEpec;
import com.fincatto.documentofiscal.cte300.webservices.WSGtv;
import com.fincatto.documentofiscal.cte300.webservices.WSInutilizacao;
import com.fincatto.documentofiscal.cte300.webservices.WSNotaConsulta;
import com.fincatto.documentofiscal.cte300.webservices.WSPrestacaoEmDesacordo;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoCTeOS;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoLote;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoLoteRetorno;
import com.fincatto.documentofiscal.cte300.webservices.WSRegistroMultimodal;
import com.fincatto.documentofiscal.cte300.webservices.WSStatusConsulta;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class WSFacade {
    private final WSStatusConsulta wsStatusConsulta;
    private final WSRecepcaoLote wsRecepcaoLote;
    private final WSNotaConsulta wsNotaConsulta;
    private final WSCancelamento wsCancelamento;
    private final WSInutilizacao wsInutilizacao;
    private final WSDistribuicaoCTe wSDistribuicaoCTe;
    private final WSRecepcaoLoteRetorno wsRecepcaoLoteRetorno;
    private final WSPrestacaoEmDesacordo wsPrestacaoEmDesacordo;
    private final WSRegistroMultimodal wsRegistroMultimodal;
    private final WSCartaCorrecao wsCartaCorrecao;
    private final WSComprovanteEntrega wsComprovanteEntrega;
    private final WSCancelamentoComprovanteEntrega wsCancelamentoComprovanteEntrega;
    private final WSEpec wsEpec;
    private final WSGtv wsGtv;
    private final WSRecepcaoCTeOS wsRecepcaoCTeOS;

    public WSFacade(CTeConfig cTeConfig) throws IOException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(cTeConfig), 443));
        this.wsStatusConsulta = new WSStatusConsulta(cTeConfig);
        this.wsRecepcaoLote = new WSRecepcaoLote(cTeConfig);
        this.wsRecepcaoLoteRetorno = new WSRecepcaoLoteRetorno(cTeConfig);
        this.wsNotaConsulta = new WSNotaConsulta(cTeConfig);
        this.wsCancelamento = new WSCancelamento(cTeConfig);
        this.wsInutilizacao = new WSInutilizacao(cTeConfig);
        this.wSDistribuicaoCTe = new WSDistribuicaoCTe(cTeConfig);
        this.wsPrestacaoEmDesacordo = new WSPrestacaoEmDesacordo(cTeConfig);
        this.wsRegistroMultimodal = new WSRegistroMultimodal(cTeConfig);
        this.wsCartaCorrecao = new WSCartaCorrecao(cTeConfig);
        this.wsComprovanteEntrega = new WSComprovanteEntrega(cTeConfig);
        this.wsCancelamentoComprovanteEntrega = new WSCancelamentoComprovanteEntrega(cTeConfig);
        this.wsEpec = new WSEpec(cTeConfig);
        this.wsGtv = new WSGtv(cTeConfig);
        this.wsRecepcaoCTeOS = new WSRecepcaoCTeOS(cTeConfig);
    }

    public CTeConsStatServRet consultaStatus(DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        return this.wsStatusConsulta.consultaStatus(dFUnidadeFederativa);
    }

    public CTeEnvioLoteRetornoDados envioRecepcaoLote(CTeEnvioLote cTeEnvioLote) throws Exception {
        return this.wsRecepcaoLote.envioRecepcao(cTeEnvioLote);
    }

    public CTeConsultaRecLoteRet consultaEnvioRecepcaoLote(String string) throws Exception {
        return this.wsRecepcaoLoteRetorno.consultaLote(string);
    }

    public CTeNotaConsultaRetorno consultaNota(String string) throws Exception {
        return this.wsNotaConsulta.consultaNota(string);
    }

    public CTeEventoRetorno cancelaNota(String string, String string2, String string3) throws Exception {
        return this.wsCancelamento.cancelaNota(string, string2, string3);
    }

    public CTeEventoRetorno cancelaNotaAssinada(String string, String string2) throws Exception {
        return this.wsCancelamento.cancelaNotaAssinada(string, string2);
    }

    public String getXmlAssinadoCancelamento(String string, String string2, String string3) throws Exception {
        return this.wsCancelamento.getXmlAssinado(string, string2, string3);
    }

    public CTeRetornoEventoInutilizacao inutilizaNotaAssinada(String string, DFModelo dFModelo) throws Exception {
        return this.wsInutilizacao.inutilizaNotaAssinada(string, dFModelo);
    }

    public CTeRetornoEventoInutilizacao inutilizaNota(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) throws Exception {
        return this.wsInutilizacao.inutilizaNota(n, string, string2, string3, string4, string5, dFModelo);
    }

    public String getXmlAssinadoInutilizacao(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) throws Exception {
        return this.wsInutilizacao.getXmlAssinado(n, string, string2, string3, string4, string5, dFModelo);
    }

    public CTDistribuicaoIntRetorno consultarDistribuicaoCTe(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3) throws Exception {
        return this.wSDistribuicaoCTe.consultar(string, dFUnidadeFederativa, string2, string3);
    }

    public CTeEventoRetorno cancelaComprovanteEntrega(String string, String string2, String string3, int n) throws Exception {
        return this.wsCancelamentoComprovanteEntrega.cancelaComprovanteEntrega(string, string2, string3, n);
    }

    public CTeEventoRetorno cancelaComprovanteEntregaAssinado(String string, String string2) throws Exception {
        return this.wsCancelamentoComprovanteEntrega.cancelaComprovanteEntregaAssinado(string, string2);
    }

    public String getXmlAssinadoCancelamentoComprovanteEntrega(String string, String string2, String string3, int n) throws Exception {
        return this.wsCancelamentoComprovanteEntrega.getXmlAssinado(string, string2, string3, n);
    }

    public CTeEventoRetorno corrigeNota(String string, String string2, String string3, String string4, Integer n, int n2) throws Exception {
        return this.wsCartaCorrecao.corrigeNota(string, string2, string3, string4, n, n2);
    }

    public CTeEventoRetorno corrigeNota(String string, List<CTeInformacaoCartaCorrecao> list, int n) throws Exception {
        return this.wsCartaCorrecao.corrigeNota(string, list, n);
    }

    public CTeEventoRetorno corrigeNotaAssinada(String string, String string2) throws Exception {
        return this.wsCartaCorrecao.corrigeNotaAssinada(string, string2);
    }

    public String getXmlAssinadoCartaCorreca(String string, List<CTeInformacaoCartaCorrecao> list, int n) throws Exception {
        return this.wsCartaCorrecao.getXmlAssinado(string, list, n);
    }

    public CTeEventoRetorno comprovanteEntrega(String string, CTeEnviaEventoComprovanteEntrega cTeEnviaEventoComprovanteEntrega, int n) throws Exception {
        return this.wsComprovanteEntrega.comprovanteEntrega(string, cTeEnviaEventoComprovanteEntrega, n);
    }

    public CTeEventoRetorno comprovanteEntregaAssinado(String string, String string2) throws Exception {
        return this.wsComprovanteEntrega.comprovanteEntregaAssinado(string, string2);
    }

    public String getXmlAssinadoComprovanteEntrega(String string, CTeEnviaEventoComprovanteEntrega cTeEnviaEventoComprovanteEntrega, int n) throws Exception {
        return this.wsComprovanteEntrega.getXmlAssinado(string, cTeEnviaEventoComprovanteEntrega, n);
    }

    public CTeEventoRetorno enviaEpec(String string, CTeEnviaEventoEpec cTeEnviaEventoEpec) throws Exception {
        return this.wsEpec.enviaEpec(string, cTeEnviaEventoEpec);
    }

    public CTeEventoRetorno enviaEpecAssinado(String string, String string2) throws Exception {
        return this.wsEpec.enviaEpecAssinado(string, string2);
    }

    public String getXmlAssinadoEpec(String string, CTeEnviaEventoEpec cTeEnviaEventoEpec) throws Exception {
        return this.wsEpec.getXmlAssinado(string, cTeEnviaEventoEpec);
    }

    public CTeEventoRetorno enviaGtv(String string, CTeEnviaEventoGtv cTeEnviaEventoGtv, int n) throws Exception {
        return this.wsGtv.enviaGtv(string, cTeEnviaEventoGtv, n);
    }

    public CTeEventoRetorno enviaGtvAssinada(String string, String string2) throws Exception {
        return this.wsGtv.enviaGtvAssinada(string, string2);
    }

    public String getXmlAssinadoGtv(String string, CTeEnviaEventoGtv cTeEnviaEventoGtv, int n) throws Exception {
        return this.wsGtv.getXmlAssinado(string, cTeEnviaEventoGtv, n);
    }

    public CTeEventoRetorno prestacaoEmDesacordo(String string, String string2, String string3, int n) throws Exception {
        return this.wsPrestacaoEmDesacordo.prestacaoEmDesacordo(string, string2, string3, n);
    }

    public CTeEventoRetorno prestacaoEmDesacordoAssinada(String string, String string2) throws Exception {
        return this.wsPrestacaoEmDesacordo.prestacaoEmDesacordoAssinada(string, string2);
    }

    public String getXmlAssinadoPrestacaoEmDesacordo(String string, String string2, String string3, int n) throws Exception {
        return this.wsPrestacaoEmDesacordo.getXmlAssinado(string, string2, string3, n);
    }

    public CTeEventoRetorno registroMultimodal(String string, String string2, String string3) throws Exception {
        return this.wsRegistroMultimodal.registroMultimodal(string, string2, string3);
    }

    public CTeEventoRetorno registroMultimodalAssinado(String string, String string2) throws Exception {
        return this.wsRegistroMultimodal.registroMultimodalAssinado(string, string2);
    }

    public String getXmlAssinadoRegistroMultimodal(String string, String string2, String string3) throws Exception {
        return this.wsRegistroMultimodal.getXmlAssinado(string, string2, string3);
    }

    public CTeOSEnvioRetornoDados envioRecepcaoLote(CTeOS cTeOS) throws Exception {
        return this.wsRecepcaoCTeOS.envioRecepcao(cTeOS);
    }
}

