/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTEnviaEventoInutilizacao;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTEventoInutilizacaoDados;
import com.fincatto.documentofiscal.cte300.classes.evento.inutilizacao.CTeRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.cte300.webservices.inutilizacao.CteInutilizacaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WSInutilizacao {
    private static final String VERSAO_SERVICO = "3.00";
    private static final String NOME_SERVICO = "INUTILIZAR";
    private static final Logger LOGGER = LoggerFactory.getLogger(WSInutilizacao.class);
    private final CTeConfig config;

    WSInutilizacao(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    CTeRetornoEventoInutilizacao inutilizaNotaAssinada(String string, DFModelo dFModelo) throws Exception {
        OMElement oMElement = this.efetuaInutilizacao(string, dFModelo);
        return (CTeRetornoEventoInutilizacao)((Object)new DFPersister().read(CTeRetornoEventoInutilizacao.class, oMElement.toString()));
    }

    CTeRetornoEventoInutilizacao inutilizaNota(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) throws Exception {
        String string6 = this.getXmlAssinado(n, string, string2, string3, string4, string5, dFModelo);
        OMElement oMElement = this.efetuaInutilizacao(string6, dFModelo);
        return (CTeRetornoEventoInutilizacao)((Object)new DFPersister().read(CTeRetornoEventoInutilizacao.class, oMElement.toString()));
    }

    String getXmlAssinado(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) throws Exception {
        String string6 = this.geraDadosInutilizacao(n, string, string2, string3, string4, string5, dFModelo).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string6);
    }

    private OMElement efetuaInutilizacao(String string, DFModelo dFModelo) throws Exception {
        CteInutilizacaoStub.CteDadosMsg cteDadosMsg = new CteInutilizacaoStub.CteDadosMsg();
        CteInutilizacaoStub.CteCabecMsgE cteCabecMsgE = new CteInutilizacaoStub.CteCabecMsgE();
        CteInutilizacaoStub.CteCabecMsg cteCabecMsg = new CteInutilizacaoStub.CteCabecMsg();
        cteCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        cteCabecMsg.setVersaoDados(VERSAO_SERVICO);
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        LOGGER.debug(oMElement.toString());
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String string2 = cTAutorizador31.getCteInutilizacao(this.config.getAmbiente());
        CteInutilizacaoStub.CteInutilizacaoCTResult cteInutilizacaoCTResult = new CteInutilizacaoStub(string2, this.config).cteInutilizacaoCT(cteDadosMsg, cteCabecMsgE);
        OMElement oMElement2 = cteInutilizacaoCTResult.getExtraElement();
        LOGGER.debug(oMElement2.toString());
        return oMElement2;
    }

    private CTEnviaEventoInutilizacao geraDadosInutilizacao(int n, String string, String string2, String string3, String string4, String string5, DFModelo dFModelo) {
        CTEnviaEventoInutilizacao cTEnviaEventoInutilizacao = new CTEnviaEventoInutilizacao();
        CTEventoInutilizacaoDados cTEventoInutilizacaoDados = new CTEventoInutilizacaoDados();
        cTEventoInutilizacaoDados.setAmbiente(this.config.getAmbiente());
        cTEventoInutilizacaoDados.setAno(n);
        cTEventoInutilizacaoDados.setCnpj(string);
        cTEventoInutilizacaoDados.setJustificativa(string5);
        cTEventoInutilizacaoDados.setModeloDocumentoFiscal(dFModelo.getCodigo());
        cTEventoInutilizacaoDados.setNomeServico(NOME_SERVICO);
        cTEventoInutilizacaoDados.setNumeroCTInicial(string3);
        cTEventoInutilizacaoDados.setNumeroCTFinal(string4);
        cTEventoInutilizacaoDados.setSerie(string2);
        cTEventoInutilizacaoDados.setUf(this.config.getCUF());
        String string6 = StringUtils.leftPad((String)string3, (int)9, (String)"0");
        String string7 = StringUtils.leftPad((String)string4, (int)9, (String)"0");
        String string8 = StringUtils.leftPad((String)string2, (int)3, (String)"0");
        cTEventoInutilizacaoDados.setIdentificador("ID" + this.config.getCUF().getCodigoIbge() + string + dFModelo.getCodigo() + string8 + string6 + string7);
        cTEnviaEventoInutilizacao.setVersao(new BigDecimal(VERSAO_SERVICO));
        cTEnviaEventoInutilizacao.setDados(cTEventoInutilizacaoDados);
        return cTEnviaEventoInutilizacao;
    }
}

