/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte300.classes.evento.multimodal.CTeEnviaEventoRegistroMultimodal;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSRegistroMultimodal
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Registro Multimodal";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_REGISTRO_MULTIMODAL = "110160";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSRegistroMultimodal(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno registroMultimodalAssinado(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno registroMultimodal(String string, String string2, String string3) throws Exception {
        String string4 = this.getXmlAssinado(string, string2, string3);
        return this.registroMultimodalAssinado(string, string4);
    }

    String getXmlAssinado(String string, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosRegistroMultimodal(string, string2, string3).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string4);
    }

    private CTeEvento gerarDadosRegistroMultimodal(String string, String string2, String string3) throws Exception {
        CTeEnviaEventoRegistroMultimodal cTeEnviaEventoRegistroMultimodal = new CTeEnviaEventoRegistroMultimodal();
        cTeEnviaEventoRegistroMultimodal.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoRegistroMultimodal.setInformacoesAdicionais(string2.trim());
        cTeEnviaEventoRegistroMultimodal.setNumero(string3.trim());
        DFXMLValidador.validaEventoRegistroMultimodalCTe300(cTeEnviaEventoRegistroMultimodal.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoRegistroMultimodal, EVENTO_REGISTRO_MULTIMODAL, null, 1);
    }
}

