/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.CTModalAquavTpNav;
import com.fincatto.documentofiscal.cte400.classes.CTTipoDirecao;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="aquav")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoModalAquaviario
extends DFBase {
    private static final long serialVersionUID = 8840293884140190481L;
    @Element(name="vPrest")
    private String valorPrestacao;
    @Element(name="vAFRMM")
    private String valorAdicionalFrete;
    @Element(name="xNavio")
    private String identificacaoNavio;
    @ElementList(name="balsa", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> balsa;
    @Element(name="nViag", required=false)
    private String numeroViagem;
    @Element(name="direc")
    private CTTipoDirecao direcao;
    @Element(name="irin")
    private String irin;
    @Element(name="tpNav", required=false)
    private CTModalAquavTpNav tpNav;
    @ElementList(name="detCont", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> container;

    public String getValorPrestacao() {
        return this.valorPrestacao;
    }

    public void setValorPrestacao(BigDecimal bigDecimal) {
        this.valorPrestacao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Presta\u00e7\u00e3o Base de C\u00e1lculo do AFRMM");
    }

    public String getValorAdicionalFrete() {
        return this.valorAdicionalFrete;
    }

    public void setValorAdicionalFrete(BigDecimal bigDecimal) {
        this.valorAdicionalFrete = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "AFRMM (Adicional de Frete para Renova\u00e7\u00e3o da Marinha Mercante)");
    }

    public String getIdentificacaoNavio() {
        return this.identificacaoNavio;
    }

    public void setIdentificacaoNavio(String string) {
        DFStringValidador.tamanho60(string, "Identifica\u00e7\u00e3o do Navio");
        this.identificacaoNavio = string;
    }

    public List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> getBalsa() {
        return this.balsa;
    }

    public void setBalsa(List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> list) {
        DFListValidador.tamanho3(list, "");
        this.balsa = list;
    }

    public String getNumeroViagem() {
        return this.numeroViagem;
    }

    public void setNumeroViagem(String string) {
        DFStringValidador.tamanho10(string, "N\u00famero da Viagem");
        this.numeroViagem = string;
    }

    public CTTipoDirecao getDirecao() {
        return this.direcao;
    }

    public void setDirecao(CTTipoDirecao cTTipoDirecao) {
        this.direcao = cTTipoDirecao;
    }

    public String getIrin() {
        return this.irin;
    }

    public CTModalAquavTpNav getTpNav() {
        return this.tpNav;
    }

    public void setTpNav(CTModalAquavTpNav cTModalAquavTpNav) {
        this.tpNav = cTModalAquavTpNav;
    }

    public void setIrin(String string) {
        DFStringValidador.tamanho10(string, "Irin do navio");
        this.irin = string;
    }

    public List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> getContainer() {
        return this.container;
    }

    public void setContainer(List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> list) {
        this.container = list;
    }
}

