/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="dest")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoDestinatario
extends DFBase {
    private static final long serialVersionUID = -8388208444958300851L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="IE", required=false)
    private String inscricaoEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="fone", required=false)
    private String telefone;
    @Element(name="ISUF", required=false)
    private String inscricaoSuframa;
    @Element(name="enderDest")
    private CTeNotaEndereco endereco;
    @Element(name="email", required=false)
    private String email;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        DFStringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        DFStringValidador.tamanho2ate60(string, "Raz\u00e3o Social ou Nome do destinat\u00e1rio");
        this.razaoSocial = string;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String string) {
        DFStringValidador.telefone(string);
        this.telefone = string;
    }

    public String getInscricaoSuframa() {
        return this.inscricaoSuframa;
    }

    public void setInscricaoSuframa(String string) {
        DFStringValidador.tamanho8a9N(string, "Inscri\u00e7\u00e3o na SUFRAMA");
        this.inscricaoSuframa = string;
    }

    public CTeNotaEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(CTeNotaEndereco cTeNotaEndereco) {
        this.endereco = cTeNotaEndereco;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        DFStringValidador.tamanho60(string, "Endere\u00e7o de email");
        DFStringValidador.email(string);
        this.email = string;
    }
}

