/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.os;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.os.CTeOSEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="toma")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeOSInfoIdentificacaoTomador
extends DFBase {
    private static final long serialVersionUID = -7014772748798643095L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="IE", required=false)
    private String inscricaoEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="fone", required=false)
    private String telefone;
    @Element(name="enderToma")
    private CTeOSEndereco enderTomadorServico;
    @Element(name="email", required=false)
    private String email;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        DFStringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        DFStringValidador.tamanho2ate60(string, "Raz\u00e3o Social ou Nome");
        this.razaoSocial = string;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome Fantasia");
        this.nomeFantasia = string;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String string) {
        DFStringValidador.telefone(string);
        this.telefone = string;
    }

    public CTeOSEndereco getEnderTomadorServico() {
        return this.enderTomadorServico;
    }

    public void setEnderTomadorServico(CTeOSEndereco cTeOSEndereco) {
        this.enderTomadorServico = cTeOSEndereco;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        DFStringValidador.tamanho60(string, "Endere\u00e7o de email");
        DFStringValidador.email(string);
        this.email = string;
    }
}

