/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.insucessoentrega.CTeEnviaEventoCancelamentoInsucessoEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCancelamentoInsucessoEntrega
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Cancelamento do Insucesso de Entrega do CT-e";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_CANCELAMENTO_INSUCESSO_DE_ENTREGA = "110191";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSCancelamentoInsucessoEntrega(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno cancelaInsucessoEntregaAssinado(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno cancelaInsucessoEntrega(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.getXmlAssinado(string, string2, string3, n);
        return this.cancelaInsucessoEntregaAssinado(string, string4);
    }

    String getXmlAssinado(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.gerarDadosCancelamentoInsucessoEntrega(string, string2, string3, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string4);
    }

    private CTeEvento gerarDadosCancelamentoInsucessoEntrega(String string, String string2, String string3, int n) throws Exception {
        CTeEnviaEventoCancelamentoInsucessoEntrega cTeEnviaEventoCancelamentoInsucessoEntrega = new CTeEnviaEventoCancelamentoInsucessoEntrega();
        cTeEnviaEventoCancelamentoInsucessoEntrega.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoCancelamentoInsucessoEntrega.setProtocoloAutorizacao(string2);
        cTeEnviaEventoCancelamentoInsucessoEntrega.setProtocoloInsucessoEntrega(string3);
        DFXMLValidador.validaEventoCancelamentoInsucessoEntregaCTe400(cTeEnviaEventoCancelamentoInsucessoEntrega.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoCancelamentoInsucessoEntrega, EVENTO_CANCELAMENTO_INSUCESSO_DE_ENTREGA, null, n);
    }
}

