/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.desacordo.CTeEnviaEventoCancelamentoPrestacaoEmDesacordo;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCancelamentoPrestacaoEmDesacordo
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Cancelamento Prestacao do Servico em Desacordo";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_CANCELAMENTO_DESACORDO = "610111";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE, DFModelo.CTeOS);

    WSCancelamentoPrestacaoEmDesacordo(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno cancelaPrestacaoEmDesacordoAssinado(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno cancelaPrestacaoEmDesacordo(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.getXmlAssinado(string, string2, string3, n);
        return this.cancelaPrestacaoEmDesacordoAssinado(string, string4);
    }

    String getXmlAssinado(String string, String string2, String string3, int n) throws Exception {
        String string4 = this.gerarDados(string, string2, string3, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string4);
    }

    private CTeEvento gerarDados(String string, String string2, String string3, int n) throws Exception {
        CTeEnviaEventoCancelamentoPrestacaoEmDesacordo cTeEnviaEventoCancelamentoPrestacaoEmDesacordo = new CTeEnviaEventoCancelamentoPrestacaoEmDesacordo();
        cTeEnviaEventoCancelamentoPrestacaoEmDesacordo.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoCancelamentoPrestacaoEmDesacordo.setProtocoloDesacordo(string2);
        DFXMLValidador.validaEventoCancelamentoPrestacaoEmDesacordoCTe400(cTeEnviaEventoCancelamentoPrestacaoEmDesacordo.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoCancelamentoPrestacaoEmDesacordo, EVENTO_CANCELAMENTO_DESACORDO, string3, n);
    }
}

