/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.cartacorrecao.CTeEnviaEventoCartaCorrecao;
import com.fincatto.documentofiscal.cte400.classes.evento.cartacorrecao.CTeInformacaoCartaCorrecao;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCartaCorrecao
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Carta de Correcao";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_CARTA_DE_CORRECAO = "110110";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE, DFModelo.CTeOS);

    WSCartaCorrecao(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno corrigeNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno corrigeNota(String string, String string2, String string3, String string4, Integer n, int n2) throws Exception {
        CTeInformacaoCartaCorrecao cTeInformacaoCartaCorrecao = new CTeInformacaoCartaCorrecao();
        cTeInformacaoCartaCorrecao.setGrupoAlterado(string2);
        cTeInformacaoCartaCorrecao.setCampoAlterado(string3);
        cTeInformacaoCartaCorrecao.setValorAlterado(string4);
        cTeInformacaoCartaCorrecao.setNumeroItemAlterado(n);
        return this.corrigeNota(string, Arrays.asList(cTeInformacaoCartaCorrecao), n2);
    }

    CTeEventoRetorno corrigeNota(String string, List<CTeInformacaoCartaCorrecao> list, int n) throws Exception {
        String string2 = this.getXmlAssinado(string, list, n);
        return this.corrigeNotaAssinada(string, string2);
    }

    String getXmlAssinado(String string, List<CTeInformacaoCartaCorrecao> list, int n) throws Exception {
        String string2 = this.gerarDadosCartaCorrecao(string, list, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string2);
    }

    private CTeEvento gerarDadosCartaCorrecao(String string, List<CTeInformacaoCartaCorrecao> list, int n) throws Exception {
        CTeEnviaEventoCartaCorrecao cTeEnviaEventoCartaCorrecao = new CTeEnviaEventoCartaCorrecao();
        cTeEnviaEventoCartaCorrecao.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoCartaCorrecao.setCorrecoes(list);
        cTeEnviaEventoCartaCorrecao.setCondicaoUso("A Carta de Correcao e disciplinada pelo Art. 58-B do CONVENIO/SINIEF 06/89: Fica permitida a utilizacao de carta de correcao, para regularizacao de erro ocorrido na emissao de documentos fiscais relativos a prestacao de servico de transporte, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da prestacao;II - a correcao de dados cadastrais que implique mudanca do emitente, tomador, remetente ou do destinatario;III - a data de emissao ou de saida.");
        DFXMLValidador.validaEventoCartaCorrecaoCTe400(cTeEnviaEventoCartaCorrecao.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoCartaCorrecao, EVENTO_CARTA_DE_CORRECAO, null, n);
    }
}

