/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetorno;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeRecepcaoSincV4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

class WSRecepcaoCTe
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoCTe(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    public CTeEnvioRetornoDados enviaCTe(CTeNota cTeNota) throws Exception {
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(cTeNota.toString(), "infCte");
        System.out.println(string);
        CTeNota cTeNota2 = (CTeNota)this.config.getPersister().read(CTeNota.class, string);
        CTeEnvioRetorno cTeEnvioRetorno = this.comunicaLote(string);
        return new CTeEnvioRetornoDados(cTeEnvioRetorno, cTeNota2);
    }

    private CTeEnvioRetorno comunicaLote(String string) throws Exception {
        String string2;
        Object object;
        DFXMLValidador.validaNotaCte400(string);
        try (Object object2 = new ByteArrayOutputStream();){
            object = new GZIPOutputStream((OutputStream)object2);
            try {
                ((FilterOutputStream)object).write(string.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                ((DeflaterOutputStream)object).close();
            }
            string2 = Base64.getEncoder().encodeToString(((ByteArrayOutputStream)object2).toByteArray());
        }
        object2 = new CTeRecepcaoSincV4Stub.CteDadosMsg();
        ((CTeRecepcaoSincV4Stub.CteDadosMsg)object2).setCteDadosMsg(string2);
        object = CTAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string3 = ((CTAutorizador400)((Object)object)).getCteRecepcaoSinc(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao, autorizador " + ((Enum)object).name() + ", UF " + this.config.getCUF().name());
        }
        CTeRecepcaoSincV4Stub.CteRecepcaoResult cteRecepcaoResult = new CTeRecepcaoSincV4Stub(string3, this.config).cteRecepcao((CTeRecepcaoSincV4Stub.CteDadosMsg)object2);
        CTeEnvioRetorno cTeEnvioRetorno = (CTeEnvioRetorno)this.config.getPersister().read(CTeEnvioRetorno.class, cteRecepcaoResult.getExtraElement().toString());
        this.getLogger().debug(cTeEnvioRetorno.toString());
        return cTeEnvioRetorno;
    }
}

