/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeOSEnvioRetorno;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeOSEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.os.CTeOS;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeRecepcaoOSV4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

class WSRecepcaoCTeOS
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoCTeOS(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    public CTeOSEnvioRetornoDados enviaCTe(CTeOS cTeOS) throws Exception {
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(cTeOS.toString(), "infCte");
        CTeOS cTeOS2 = (CTeOS)this.config.getPersister().read(CTeOS.class, string);
        CTeOSEnvioRetorno cTeOSEnvioRetorno = this.comunicaLote(string);
        return new CTeOSEnvioRetornoDados(cTeOSEnvioRetorno, cTeOS2);
    }

    private CTeOSEnvioRetorno comunicaLote(String string) throws Exception {
        String string2;
        Object object;
        DFXMLValidador.validaNotaCTeOS400(string);
        try (Object object2 = new ByteArrayOutputStream();){
            object = new GZIPOutputStream((OutputStream)object2);
            try {
                ((FilterOutputStream)object).write(string.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                ((DeflaterOutputStream)object).close();
            }
            string2 = Base64.getEncoder().encodeToString(((ByteArrayOutputStream)object2).toByteArray());
        }
        object2 = new CTeRecepcaoOSV4Stub.CteDadosMsg();
        ((CTeRecepcaoOSV4Stub.CteDadosMsg)object2).setCteDadosMsg(string2);
        object = CTAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string3 = ((CTAutorizador400)((Object)object)).getCteRecepcaoOS(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao OS, autorizador " + ((Enum)object).name() + ", UF " + this.config.getCUF().name());
        }
        CTeRecepcaoOSV4Stub.CteRecepcaoOSResult cteRecepcaoOSResult = new CTeRecepcaoOSV4Stub(string3, this.config).cteRecepcaoOS((CTeRecepcaoOSV4Stub.CteDadosMsg)object2);
        CTeOSEnvioRetorno cTeOSEnvioRetorno = (CTeOSEnvioRetorno)this.config.getPersister().read(CTeOSEnvioRetorno.class, cteRecepcaoOSResult.getExtraElement().toString());
        this.getLogger().debug(cTeOSEnvioRetorno.toString());
        return cTeOSEnvioRetorno;
    }
}

