/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.consultastatusservico.CTeConsStatServ;
import com.fincatto.documentofiscal.cte400.classes.consultastatusservico.CTeConsStatServRet;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeStatusServicoV4Stub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final CTeConfig config;

    WSStatusConsulta(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    CTeConsStatServRet consultaStatus(DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)WSStatusConsulta.gerarDadosConsulta(this.config, dFUnidadeFederativa).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsultaStatus(oMElement, dFUnidadeFederativa);
        this.getLogger().debug(oMElement2.toString());
        return (CTeConsStatServRet)this.config.getPersister().read(CTeConsStatServRet.class, oMElement2.toString());
    }

    private static CTeConsStatServ gerarDadosConsulta(CTeConfig cTeConfig, DFUnidadeFederativa dFUnidadeFederativa) {
        CTeConsStatServ cTeConsStatServ = new CTeConsStatServ();
        cTeConsStatServ.setVersao("4.00");
        cTeConsStatServ.setAmbiente(cTeConfig.getAmbiente());
        cTeConsStatServ.setUf(dFUnidadeFederativa.getCodigoIbge());
        cTeConsStatServ.setServico(NOME_SERVICO);
        return cTeConsStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement oMElement, DFUnidadeFederativa dFUnidadeFederativa) throws RemoteException {
        CTeStatusServicoV4Stub.CteDadosMsg cteDadosMsg = new CTeStatusServicoV4Stub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador400 cTAutorizador400 = CTAutorizador400.valueOfCodigoUF(dFUnidadeFederativa);
        String string = cTAutorizador400.getCteStatusServico(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico, autorizador " + cTAutorizador400.name() + ", UF " + dFUnidadeFederativa.name());
        }
        return new CTeStatusServicoV4Stub(string, this.config).cteStatusServicoCT(cteDadosMsg).getExtraElement();
    }
}

