/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe.webservices.distribuicao;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe.classes.distribuicao.MDFeDistribuicaoConsultaNSU;
import com.fincatto.documentofiscal.mdfe.classes.distribuicao.MDFeDistribuicaoInt;
import com.fincatto.documentofiscal.mdfe.classes.distribuicao.MDFeDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.mdfe.classes.distribuicao.MDFeDistribuicaoNSU;
import com.fincatto.documentofiscal.mdfe.webservices.distribuicao.MDFeDistribuicaoDFeStub;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;

public class WSDistribuicaoMDFe {
    private final MDFeConfig config;

    public WSDistribuicaoMDFe(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    public MDFeDistribuicaoIntRetorno consultar(String string, DFUnidadeFederativa dFUnidadeFederativa, String string2, String string3) throws Exception {
        try {
            String string4 = this.gerarMDFeDistribuicaoInt(string, string2, string3).toString();
            DFXMLValidador.validaDistribuicaoMDFe(string4);
            OMElement oMElement = AXIOMUtil.stringToOM((String)string4);
            MDFeDistribuicaoDFeStub.MdfeDadosMsg mdfeDadosMsg = new MDFeDistribuicaoDFeStub.MdfeDadosMsg();
            mdfeDadosMsg.setExtraElement(oMElement);
            MDFeDistribuicaoDFeStub.MdfeCabecMsg mdfeCabecMsg = new MDFeDistribuicaoDFeStub.MdfeCabecMsg();
            mdfeCabecMsg.setCUF(dFUnidadeFederativa.getCodigo());
            mdfeCabecMsg.setVersaoDados("1.00");
            MDFeDistribuicaoDFeStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeDistribuicaoDFeStub.MdfeCabecMsgE();
            mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
            MDFeDistribuicaoDFeStub mDFeDistribuicaoDFeStub = new MDFeDistribuicaoDFeStub(MDFAutorizador3.RS.getMDFeDistribuicao(this.config.getAmbiente()));
            MDFeDistribuicaoDFeStub.MdfeDistDFeInteresseResult mdfeDistDFeInteresseResult = mDFeDistribuicaoDFeStub.mdfeDistDFeInteresse(mdfeDadosMsg, mdfeCabecMsgE);
            return (MDFeDistribuicaoIntRetorno)this.config.getPersister().read(MDFeDistribuicaoIntRetorno.class, mdfeDistDFeInteresseResult.getExtraElement().toString());
        }
        catch (RemoteException | XMLStreamException exception) {
            throw new Exception(exception.getMessage());
        }
    }

    private MDFeDistribuicaoInt gerarMDFeDistribuicaoInt(String string, String string2, String string3) {
        MDFeDistribuicaoInt mDFeDistribuicaoInt = new MDFeDistribuicaoInt();
        mDFeDistribuicaoInt.setVersao("1.00");
        mDFeDistribuicaoInt.setAmbiente(this.config.getAmbiente());
        if (string.length() == 11) {
            mDFeDistribuicaoInt.setCpf(string);
        } else {
            mDFeDistribuicaoInt.setCnpj(string);
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            mDFeDistribuicaoInt.setDistribuicao(new MDFeDistribuicaoNSU().setUltimoNSU(string3));
        } else {
            mDFeDistribuicaoInt.setConsulta(new MDFeDistribuicaoConsultaNSU().setNsu(string2));
        }
        return mDFeDistribuicaoInt;
    }

    public static String decodeGZipToXml(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return "";
        }
        byte[] byArray = Base64.getDecoder().decode(string);
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));){
            String string2;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gZIPInputStream, StandardCharsets.UTF_8));){
                String string3;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
                string2 = stringBuilder.toString();
            }
            return string2;
        }
    }
}

