/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoEmitenteEndereco;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="emit")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoEmitente
extends DFBase {
    private static final long serialVersionUID = 6209368588212530094L;
    private static final String INFO = "Emitente do Manifesto";
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="enderEmit")
    private MDFInfoEmitenteEndereco endereco;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null && string != null) {
            throw new IllegalStateException("Nao pode setar CNPJ caso CPF esteja setado");
        }
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null && string != null) {
            throw new IllegalStateException("Nao pode setar CPF caso CNPJ esteja setado");
        }
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getCpfj() {
        String string = "";
        if (StringUtils.isNotBlank((CharSequence)this.cpf)) {
            string = this.cpf;
        } else if (StringUtils.isNotBlank((CharSequence)this.cnpj)) {
            string = this.cnpj;
        }
        return string;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        this.inscricaoEstadual = DFStringValidador.inscricaoEstadualSemIsencao(string, INFO);
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        DFStringValidador.tamanho2ate60(string, "Raz\u00e3o social ou Nome em Emitente do Manifesto");
        this.razaoSocial = string;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome fantasia em Emitente do Manifesto");
        this.nomeFantasia = string;
    }

    public MDFInfoEmitenteEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(MDFInfoEmitenteEndereco mDFInfoEmitenteEndereco) {
        this.endereco = mDFInfoEmitenteEndereco;
    }
}

