/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoResponsavelSeguro;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infResp")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoSeguroResponsavel
extends DFBase {
    private static final long serialVersionUID = -7502457926490945458L;
    private static final String INFO = "Respons\u00e1vel pelo seguro da carga";
    @Element(name="respSeg")
    private MDFTipoResponsavelSeguro responsavelSeguro;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado em Respons\u00e1vel pelo seguro da carga");
        }
        this.cnpj = DFStringValidador.cnpj(string, INFO);
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado em Respons\u00e1vel pelo seguro da carga");
        }
        this.cpf = DFStringValidador.cpf(string, INFO);
    }

    public MDFTipoResponsavelSeguro getResponsavelSeguro() {
        return this.responsavelSeguro;
    }

    public void setResponsavelSeguro(MDFTipoResponsavelSeguro mDFTipoResponsavelSeguro) {
        this.responsavelSeguro = mDFTipoResponsavelSeguro;
    }

    @Override
    public String toString() {
        if (StringUtils.isBlank((CharSequence)this.getCnpj()) && StringUtils.isBlank((CharSequence)this.getCpf()) && this.getResponsavelSeguro().equals((Object)MDFTipoResponsavelSeguro.CONTRATANTE_MDFE)) {
            throw new IllegalStateException("Obrigat\u00f3rio CPF ou CNPJ do respons\u00e1vel pelo seguro para (2) respons\u00e1vel pela contrata\u00e7\u00e3o do transporte.");
        }
        return super.toString();
    }
}

