/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFUnidadeMedidaPesoBrutoCarga;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class MDFInfoTotal
extends DFBase {
    private static final long serialVersionUID = 8455307264727288428L;
    @Element(name="qCTe", required=false)
    private String qtdeCTe;
    @Element(name="qNFe", required=false)
    private String qtdeNFe;
    @Element(name="qMDFe", required=false)
    private String qtdeMDFe;
    @Element(name="vCarga")
    private String valorTotalCarga;
    @Element(name="cUnid")
    private MDFUnidadeMedidaPesoBrutoCarga unidadeMedidaPesoBrutoCarga;
    @Element(name="qCarga")
    private String pesoCarga;

    public String getQtdeCTe() {
        return this.qtdeCTe;
    }

    public void setQtdeCTe(String string) {
        this.qtdeCTe = DFStringValidador.validador(string, "Total CT-e no MDF-e", 6, false, true);
    }

    public String getQtdeNFe() {
        return this.qtdeNFe;
    }

    public void setQtdeNFe(String string) {
        this.qtdeNFe = DFStringValidador.validador(string, "Total NF-e no MDF-e", 6, false, true);
    }

    public String getQtdeMDFe() {
        return this.qtdeMDFe;
    }

    public void setQtdeMDFe(String string) {
        this.qtdeMDFe = DFStringValidador.validador(string, "Total MDF-e no MDF-e relacionados no Manifesto Aquavi\u00e1rio", 6, false, true);
    }

    public String getValorTotalCarga() {
        return this.valorTotalCarga;
    }

    public void setValorTotalCarga(BigDecimal bigDecimal) {
        this.valorTotalCarga = DFBigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor total da carga ");
    }

    public MDFUnidadeMedidaPesoBrutoCarga getUnidadeMedidaPesoBrutoCarga() {
        return this.unidadeMedidaPesoBrutoCarga;
    }

    public void setUnidadeMedidaPesoBrutoCarga(MDFUnidadeMedidaPesoBrutoCarga mDFUnidadeMedidaPesoBrutoCarga) {
        this.unidadeMedidaPesoBrutoCarga = mDFUnidadeMedidaPesoBrutoCarga;
    }

    public String getPesoCarga() {
        return this.pesoCarga;
    }

    public void setPesoCarga(BigDecimal bigDecimal) {
        this.pesoCarga = DFBigDecimalValidador.validaTamanho(bigDecimal, "Peso Bruto da Carga", 11, 4, true);
    }
}

