/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.utils;

import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoEmissao;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFe;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;

public class MDFGeraQRCode {
    private final MDFe mdf;
    private final MDFeConfig config;
    private static String qrCodeUrl = "https://dfe-portal.svrs.rs.gov.br/mdfe/qrCode";

    public MDFGeraQRCode(MDFe mDFe, MDFeConfig mDFeConfig) {
        this.mdf = mDFe;
        this.config = mDFeConfig;
    }

    public String getQRCode() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String string = qrCodeUrl;
        String string2 = this.mdf.getInfo().getChaveAcesso();
        stringBuilder.append("chMDFe=").append(string2).append("&");
        stringBuilder.append("tpAmb=").append(this.config.getAmbiente().getCodigo());
        if (this.config.getTipoEmissao().equals((Object)MDFTipoEmissao.CONTINGENCIA)) {
            stringBuilder.append("&sign=").append(new DFAssinaturaDigital(this.config).assinarString(string2));
        }
        return string + "?" + stringBuilder.toString();
    }

    public String urlConsultaChaveAcesso() {
        return "https://dfe-portal.svrs.rs.gov.br/MDFe/consulta";
    }
}

