/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados.MDFeConsultaNaoEncerrados;
import com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados.MDFeConsultaNaoEncerradosRetorno;
import com.fincatto.documentofiscal.mdfe3.webservices.consultanaoencerrado.MDFeConsNaoEncStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaNaoEncerrados
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR N\u00c3O ENCERRADOS";
    private final MDFeConfig config;

    WSConsultaNaoEncerrados(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    MDFeConsultaNaoEncerradosRetorno consultaNaoEncerrados(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsultaStatus(oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (MDFeConsultaNaoEncerradosRetorno)this.config.getPersister().read(MDFeConsultaNaoEncerradosRetorno.class, oMElement2.toString());
    }

    private MDFeConsultaNaoEncerrados gerarDadosConsulta(String string) {
        MDFeConsultaNaoEncerrados mDFeConsultaNaoEncerrados = new MDFeConsultaNaoEncerrados();
        mDFeConsultaNaoEncerrados.setAmbiente(this.config.getAmbiente());
        mDFeConsultaNaoEncerrados.setVersao("3.00");
        mDFeConsultaNaoEncerrados.setCnpj(string);
        mDFeConsultaNaoEncerrados.setServico(NOME_SERVICO);
        return mDFeConsultaNaoEncerrados;
    }

    private OMElement efetuaConsultaStatus(OMElement oMElement) throws RemoteException {
        MDFeConsNaoEncStub.MdfeCabecMsg mdfeCabecMsg = new MDFeConsNaoEncStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        mdfeCabecMsg.setVersaoDados("3.00");
        MDFeConsNaoEncStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeConsNaoEncStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        MDFeConsNaoEncStub.MdfeDadosMsg mdfeDadosMsg = new MDFeConsNaoEncStub.MdfeDadosMsg();
        mdfeDadosMsg.setExtraElement(oMElement);
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String string = mDFAutorizador3.getMDFeConsNaoEnc(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para CONSULTAR NAO ENCERRADOS, autorizador " + mDFAutorizador3.name() + ", UF " + this.config.getCUF().name());
        }
        this.getLogger().debug(string);
        MDFeConsNaoEncStub.MdfeConsNaoEncResult mdfeConsNaoEncResult = new MDFeConsNaoEncStub(string, this.config).mdfeConsNaoEnc(mdfeDadosMsg, mdfeCabecMsgE);
        return mdfeConsNaoEncResult.getExtraElement();
    }
}

