/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.nota.consulta.MDFeNotaConsulta;
import com.fincatto.documentofiscal.mdfe3.classes.nota.consulta.MDFeNotaConsultaRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.parsers.MDFChaveParser;
import com.fincatto.documentofiscal.mdfe3.webservices.consulta.MDFeConsultaStub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "3.00";
    private final MDFeConfig config;

    WSNotaConsulta(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    public MDFeNotaConsultaRetorno consultaNota(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, string);
        this.getLogger().debug(oMElement2.toString());
        return (MDFeNotaConsultaRetorno)this.config.getPersister().read(MDFeNotaConsultaRetorno.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(OMElement oMElement, String string) throws Exception {
        MDFChaveParser mDFChaveParser = new MDFChaveParser(string);
        MDFeConsultaStub.MdfeCabecMsg mdfeCabecMsg = new MDFeConsultaStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(mDFChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        mdfeCabecMsg.setVersaoDados(VERSAO_SERVICO);
        MDFeConsultaStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeConsultaStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        MDFeConsultaStub.MdfeDadosMsg mdfeDadosMsg = new MDFeConsultaStub.MdfeDadosMsg();
        mdfeDadosMsg.setExtraElement(oMElement);
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String string2 = mDFAutorizador3.getMDFeConsulta(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta, autorizador " + mDFAutorizador3.name() + ", UF " + this.config.getCUF().name());
        }
        MDFeConsultaStub.MdfeConsultaMDFResult mdfeConsultaMDFResult = new MDFeConsultaStub(string2, this.config).mdfeConsultaMDF(mdfeDadosMsg, mdfeCabecMsgE);
        return mdfeConsultaMDFResult.getExtraElement();
    }

    private MDFeNotaConsulta gerarDadosConsulta(String string) {
        MDFeNotaConsulta mDFeNotaConsulta = new MDFeNotaConsulta();
        mDFeNotaConsulta.setAmbiente(this.config.getAmbiente());
        mDFeNotaConsulta.setChave(string);
        mDFeNotaConsulta.setServico(NOME_SERVICO);
        mDFeNotaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return mDFeNotaConsulta;
    }
}

