/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoFatura
extends DFBase {
    private static final long serialVersionUID = 3308281411924779862L;
    @Element(name="nFat", required=false)
    private String numeroFatura;
    @Element(name="vOrig", required=false)
    private String valorOriginalFatura;
    @Element(name="vDesc", required=false)
    private String valorDesconto;
    @Element(name="vLiq", required=false)
    private String valorLiquidoFatura;

    public void setNumeroFatura(String string) {
        DFStringValidador.tamanho60(string, "Numero Fatura");
        this.numeroFatura = string;
    }

    public void setValorOriginalFatura(BigDecimal bigDecimal) {
        this.valorOriginalFatura = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Original Fatura");
    }

    public void setValorDesconto(BigDecimal bigDecimal) {
        this.valorDesconto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Desconto Fatura");
    }

    public void setValorLiquidoFatura(BigDecimal bigDecimal) {
        this.valorLiquidoFatura = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Liquido Fatura");
    }

    public String getValorOriginalFatura() {
        return this.valorOriginalFatura;
    }

    public String getValorDesconto() {
        return this.valorDesconto;
    }

    public String getValorLiquidoFatura() {
        return this.valorLiquidoFatura;
    }

    public String getNumeroFatura() {
        return this.numeroFatura;
    }
}

