/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe310.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe310.classes.NFFormaPagamentoPrazo;
import com.fincatto.documentofiscal.nfe310.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe310.classes.NFTipo;
import com.fincatto.documentofiscal.nfe310.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFOperacaoConsumidorFinal;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.ZonedDateTime;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = -2568396066960865875L;
    @Element(name="cUF")
    private DFUnidadeFederativa uf;
    @Element(name="cNF")
    private String codigoRandomico;
    @Element(name="natOp")
    private String naturezaOperacao;
    @Element(name="indPag")
    private NFFormaPagamentoPrazo formaPagamento;
    @Element(name="mod")
    private DFModelo modelo;
    @Element(name="serie")
    private String serie;
    @Element(name="nNF")
    private String numeroNota;
    @Element(name="dhEmi")
    private ZonedDateTime dataHoraEmissao;
    @Element(name="dhSaiEnt", required=false)
    private ZonedDateTime dataHoraSaidaOuEntrada;
    @Element(name="tpNF")
    private NFTipo tipo;
    @Element(name="idDest")
    private NFIdentificadorLocalDestinoOperacao identificadorLocalDestinoOperacao;
    @Element(name="cMunFG")
    private String codigoMunicipio;
    @Element(name="tpImp")
    private NFTipoImpressao tipoImpressao;
    @Element(name="tpEmis")
    private NFTipoEmissao tipoEmissao;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="finNFe")
    private NFFinalidade finalidade;
    @Element(name="indFinal")
    private NFOperacaoConsumidorFinal operacaoConsumidorFinal;
    @Element(name="indPres")
    private NFIndicadorPresencaComprador indicadorPresencaComprador;
    @Element(name="procEmi")
    private NFProcessoEmissor programaEmissor;
    @Element(name="verProc")
    private String versaoEmissor;
    @Element(name="dhCont", required=false)
    private ZonedDateTime dataHoraContigencia;
    @Element(name="xJust", required=false)
    private String justificativaEntradaContingencia;
    @ElementList(entry="NFref", inline=true, required=false)
    private List<NFInfoReferenciada> referenciadas;

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa;
    }

    public void setCodigoRandomico(String string) {
        DFStringValidador.exatamente8(string, "Codigo Randomico");
        this.codigoRandomico = string;
    }

    public void setNaturezaOperacao(String string) {
        DFStringValidador.tamanho60(string, "Natureza da Operacao");
        this.naturezaOperacao = string;
    }

    public void setFormaPagamento(NFFormaPagamentoPrazo nFFormaPagamentoPrazo) {
        this.formaPagamento = nFFormaPagamentoPrazo;
    }

    public void setModelo(DFModelo dFModelo) {
        this.modelo = dFModelo;
    }

    public void setSerie(String string) {
        DFStringValidador.tamanho3(string, "Serie");
        this.serie = string;
    }

    public void setNumeroNota(String string) {
        DFStringValidador.tamanho9(string, "Numero da Nota");
        this.numeroNota = string;
    }

    public void setDataHoraEmissao(ZonedDateTime zonedDateTime) {
        this.dataHoraEmissao = zonedDateTime;
    }

    public void setDataHoraSaidaOuEntrada(ZonedDateTime zonedDateTime) {
        this.dataHoraSaidaOuEntrada = zonedDateTime;
    }

    public void setTipo(NFTipo nFTipo) {
        this.tipo = nFTipo;
    }

    public void setCodigoMunicipio(String string) {
        DFStringValidador.exatamente7N(string, "Codigo Municipio");
        this.codigoMunicipio = string;
    }

    public void setReferenciadas(List<NFInfoReferenciada> list) {
        DFListValidador.tamanho500(list, "Referenciadas");
        this.referenciadas = list;
    }

    public void setTipoImpressao(NFTipoImpressao nFTipoImpressao) {
        this.tipoImpressao = nFTipoImpressao;
    }

    public void setTipoEmissao(NFTipoEmissao nFTipoEmissao) {
        this.tipoEmissao = nFTipoEmissao;
    }

    public void setDigitoVerificador(Integer n) {
        DFIntegerValidador.exatamente1(n, "DV");
        this.digitoVerificador = n;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public void setFinalidade(NFFinalidade nFFinalidade) {
        this.finalidade = nFFinalidade;
    }

    public void setProgramaEmissor(NFProcessoEmissor nFProcessoEmissor) {
        this.programaEmissor = nFProcessoEmissor;
    }

    public void setVersaoEmissor(String string) {
        DFStringValidador.tamanho20(string, "Versao Emissor");
        this.versaoEmissor = string;
    }

    public void setDataHoraContigencia(ZonedDateTime zonedDateTime) {
        this.dataHoraContigencia = zonedDateTime;
    }

    public void setJustificativaEntradaContingencia(String string) {
        DFStringValidador.tamanho15a256(string, "Justificativa Entrada Contingencia");
        this.justificativaEntradaContingencia = string;
    }

    public void setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao nFIdentificadorLocalDestinoOperacao) {
        this.identificadorLocalDestinoOperacao = nFIdentificadorLocalDestinoOperacao;
    }

    public void setOperacaoConsumidorFinal(NFOperacaoConsumidorFinal nFOperacaoConsumidorFinal) {
        this.operacaoConsumidorFinal = nFOperacaoConsumidorFinal;
    }

    public void setIndicadorPresencaComprador(NFIndicadorPresencaComprador nFIndicadorPresencaComprador) {
        this.indicadorPresencaComprador = nFIndicadorPresencaComprador;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public String getCodigoRandomico() {
        return this.codigoRandomico;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public NFFormaPagamentoPrazo getFormaPagamento() {
        return this.formaPagamento;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public String getSerie() {
        return this.serie;
    }

    public String getNumeroNota() {
        return this.numeroNota;
    }

    public ZonedDateTime getDataHoraEmissao() {
        return this.dataHoraEmissao;
    }

    public ZonedDateTime getDataHoraSaidaOuEntrada() {
        return this.dataHoraSaidaOuEntrada;
    }

    public NFTipo getTipo() {
        return this.tipo;
    }

    public NFIdentificadorLocalDestinoOperacao getIdentificadorLocalDestinoOperacao() {
        return this.identificadorLocalDestinoOperacao;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public NFTipoImpressao getTipoImpressao() {
        return this.tipoImpressao;
    }

    public NFTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public NFFinalidade getFinalidade() {
        return this.finalidade;
    }

    public NFOperacaoConsumidorFinal getOperacaoConsumidorFinal() {
        return this.operacaoConsumidorFinal;
    }

    public NFIndicadorPresencaComprador getIndicadorPresencaComprador() {
        return this.indicadorPresencaComprador;
    }

    public NFProcessoEmissor getProgramaEmissor() {
        return this.programaEmissor;
    }

    public String getVersaoEmissor() {
        return this.versaoEmissor;
    }

    public ZonedDateTime getDataHoraContigencia() {
        return this.dataHoraContigencia;
    }

    public String getJustificativaEntradaContingencia() {
        return this.justificativaEntradaContingencia;
    }

    public List<NFInfoReferenciada> getReferenciadas() {
        return this.referenciadas;
    }
}

