/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoPISST
extends DFBase {
    private static final long serialVersionUID = 3395149664389917725L;
    @Element(name="vBC", required=false)
    private String valorBaseCalculo = null;
    @Element(name="pPIS", required=false)
    private String percentualAliquota = null;
    @Element(name="qBCProd", required=false)
    private String quantidadeVendida = null;
    @Element(name="vAliqProd", required=false)
    private String valorAliquota = null;
    @Element(name="vPIS")
    private String valorTributo = null;

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        if (this.valorAliquota != null || this.quantidadeVendida != null) {
            throw new IllegalStateException("Nao pode setar percentual aliquota caso valor aliquota ou quantidade vendida esteja setado");
        }
        this.valorBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC PIS ST Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        if (this.valorAliquota != null || this.quantidadeVendida != null) {
            throw new IllegalStateException("Nao pode setar percentual aliquota caso valor aliquota ou quantidade vendida esteja setado");
        }
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota PIS ST Item");
    }

    public void setQuantidadeVendida(BigDecimal bigDecimal) {
        if (this.percentualAliquota != null || this.valorBaseCalculo != null) {
            throw new IllegalStateException("Nao pode setar valor aliquota caso percentual aliquota ou valor base calculo esteja setado");
        }
        this.quantidadeVendida = DFBigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Quantidade Vendida PIS ST Item");
    }

    public void setValorAliquota(BigDecimal bigDecimal) {
        if (this.percentualAliquota != null || this.valorBaseCalculo != null) {
            throw new IllegalStateException("Nao pode setar valor aliquota caso percentual aliquota ou valor base calculo esteja setado");
        }
        this.valorAliquota = DFBigDecimalValidador.tamanho15Com4CasasDecimais(bigDecimal, "Valor Aliquota PIS ST Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo PIS ST Item");
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getQuantidadeVendida() {
        return this.quantidadeVendida;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }
}

