/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoMedicamento
extends DFBase {
    private static final long serialVersionUID = 3127772234811692432L;
    @Element(name="nLote")
    private String lote = null;
    @Element(name="qLote")
    private String quantidade = null;
    @Element(name="dFab")
    private LocalDate dataFabricacao = null;
    @Element(name="dVal")
    private LocalDate dataValidade = null;
    @Element(name="vPMC")
    private String precoMaximoConsumidor = null;

    public void setLote(String string) {
        DFStringValidador.tamanho20(string, "Lote Medicamento");
        this.lote = string;
    }

    public void setQuantidade(BigDecimal bigDecimal) {
        this.quantidade = DFBigDecimalValidador.tamanho11Com3CasasDecimais(bigDecimal, "Quantidade Medicamento");
    }

    public void setDataFabricacao(LocalDate localDate) {
        this.dataFabricacao = localDate;
    }

    public void setDataValidade(LocalDate localDate) {
        this.dataValidade = localDate;
    }

    public void setPrecoMaximoConsumidor(BigDecimal bigDecimal) {
        this.precoMaximoConsumidor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Preco Maximo Consumidor Medicamento");
    }

    public String getLote() {
        return this.lote;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public LocalDate getDataFabricacao() {
        return this.dataFabricacao;
    }

    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    public String getPrecoMaximoConsumidor() {
        return this.precoMaximoConsumidor;
    }
}

