/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoCombustivelTipo;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoEspecieVeiculo;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemProdutoVeiculoCondicao;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemProdutoVeiculoCondicaoChassi;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemProdutoVeiculoRestricao;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemProdutoVeiculoTipoOperacao;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoTipoVeiculo;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoVeiculoCor;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoVeiculo
extends DFBase {
    private static final long serialVersionUID = -8723829235875523827L;
    @Element(name="tpOp")
    private NFNotaInfoItemProdutoVeiculoTipoOperacao tipoOperacao;
    @Element(name="chassi")
    private String chassi;
    @Element(name="cCor")
    private String codigoCor;
    @Element(name="xCor")
    private String descricaoCor;
    @Element(name="pot")
    private String potencia;
    @Element(name="cilin")
    private String cilindrada;
    @Element(name="pesoL")
    private String pesoLiquido;
    @Element(name="pesoB")
    private String pesoBruto;
    @Element(name="nSerie")
    private String numeroSerie;
    @Element(name="tpComb")
    private NFNotaInfoCombustivelTipo tipoCombustivel;
    @Element(name="nMotor")
    private String numeroMotor;
    @Element(name="CMT")
    private String capacidadeMaximaTracao;
    @Element(name="dist")
    private String distanciaEntreEixos;
    @Element(name="anoMod")
    private Integer anoModeloFabricacao;
    @Element(name="anoFab")
    private Integer anoFabricacao;
    @Element(name="tpPint")
    private String tipoPintura;
    @Element(name="tpVeic")
    private NFNotaInfoTipoVeiculo tipoVeiculo;
    @Element(name="espVeic")
    private NFNotaInfoEspecieVeiculo especieVeiculo;
    @Element(name="VIN")
    private NFNotaInfoItemProdutoVeiculoCondicaoChassi condicaoChassi;
    @Element(name="condVeic")
    private NFNotaInfoItemProdutoVeiculoCondicao condicao;
    @Element(name="cMod")
    private String codigoMarcaModelo;
    @Element(name="cCorDENATRAN")
    private NFNotaInfoVeiculoCor corDENATRAN;
    @Element(name="lota")
    private Integer lotacao;
    @Element(name="tpRest")
    private NFNotaInfoItemProdutoVeiculoRestricao restricao;

    public void setTipoOperacao(NFNotaInfoItemProdutoVeiculoTipoOperacao nFNotaInfoItemProdutoVeiculoTipoOperacao) {
        this.tipoOperacao = nFNotaInfoItemProdutoVeiculoTipoOperacao;
    }

    public void setChassi(String string) {
        DFStringValidador.exatamente17(string, "Chassi Veiculo");
        this.chassi = string;
    }

    public void setCodigoCor(String string) {
        DFStringValidador.exatamente4(string, "Codigo Cor Veiculo");
        this.codigoCor = string;
    }

    public void setDescricaoCor(String string) {
        DFStringValidador.tamanho40(string, "Descricao Cor Veiculo");
        this.descricaoCor = string;
    }

    public void setPotencia(String string) {
        DFStringValidador.exatamente4(string, "Potencia Veiculo");
        this.potencia = string;
    }

    public void setCilindrada(String string) {
        DFStringValidador.exatamente4(string, "Cilindrada Veiculo");
        this.cilindrada = string;
    }

    public void setPesoLiquido(BigDecimal bigDecimal) {
        this.pesoLiquido = DFBigDecimalValidador.tamanho9Com4CasasDecimais(bigDecimal, "Peso Liquido Veiculo");
    }

    public void setPesoBruto(BigDecimal bigDecimal) {
        this.pesoBruto = DFBigDecimalValidador.tamanho9Com4CasasDecimais(bigDecimal, "Peso Bruto Veiculo");
    }

    public void setNumeroSerie(String string) {
        DFStringValidador.exatamente9(string, "Numero Serie Veiculo");
        this.numeroSerie = string;
    }

    public void setTipoCombustivel(NFNotaInfoCombustivelTipo nFNotaInfoCombustivelTipo) {
        this.tipoCombustivel = nFNotaInfoCombustivelTipo;
    }

    public void setNumeroMotor(String string) {
        DFStringValidador.exatamente21(string, "Numero Motor Veiculo");
        this.numeroMotor = string;
    }

    public void setCapacidadeMaximaTracao(BigDecimal bigDecimal) {
        this.capacidadeMaximaTracao = DFBigDecimalValidador.tamanho9Com4CasasDecimais(bigDecimal, "Capacidade Maxima Tracao Veiculo");
    }

    public void setDistanciaEntreEixos(String string) {
        DFStringValidador.exatamente4(string, "Distancia Entre Eixos Veiculo");
        this.distanciaEntreEixos = string;
    }

    public void setAnoModeloFabricacao(int n) {
        DFIntegerValidador.exatamente4(n, "Ano Modelo Fabricacao Veiculo");
        this.anoModeloFabricacao = n;
    }

    public void setAnoFabricacao(int n) {
        DFIntegerValidador.exatamente4(n, "Ano Fabricacao Veiculo");
        this.anoFabricacao = n;
    }

    public void setTipoPintura(String string) {
        DFStringValidador.exatamente1(string, "Tipo Pintura Veiculo");
        this.tipoPintura = string;
    }

    public void setTipoVeiculo(NFNotaInfoTipoVeiculo nFNotaInfoTipoVeiculo) {
        this.tipoVeiculo = nFNotaInfoTipoVeiculo;
    }

    public void setEspecieVeiculo(NFNotaInfoEspecieVeiculo nFNotaInfoEspecieVeiculo) {
        this.especieVeiculo = nFNotaInfoEspecieVeiculo;
    }

    public void setCondicaoChassi(NFNotaInfoItemProdutoVeiculoCondicaoChassi nFNotaInfoItemProdutoVeiculoCondicaoChassi) {
        this.condicaoChassi = nFNotaInfoItemProdutoVeiculoCondicaoChassi;
    }

    public void setCondicao(NFNotaInfoItemProdutoVeiculoCondicao nFNotaInfoItemProdutoVeiculoCondicao) {
        this.condicao = nFNotaInfoItemProdutoVeiculoCondicao;
    }

    public void setCodigoMarcaModelo(String string) {
        DFStringValidador.exatamente6N(string, "Codigo Marca Modelo Veiculo");
        this.codigoMarcaModelo = string;
    }

    public void setCodigoCorDENATRAN(NFNotaInfoVeiculoCor nFNotaInfoVeiculoCor) {
        this.corDENATRAN = nFNotaInfoVeiculoCor;
    }

    public void setLotacao(int n) {
        DFIntegerValidador.tamanho3(n, "Lotacao Veiculo");
        this.lotacao = n;
    }

    public void setRestricao(NFNotaInfoItemProdutoVeiculoRestricao nFNotaInfoItemProdutoVeiculoRestricao) {
        this.restricao = nFNotaInfoItemProdutoVeiculoRestricao;
    }

    public NFNotaInfoItemProdutoVeiculoTipoOperacao getTipoOperacao() {
        return this.tipoOperacao;
    }

    public String getChassi() {
        return this.chassi;
    }

    public String getCodigoCor() {
        return this.codigoCor;
    }

    public String getDescricaoCor() {
        return this.descricaoCor;
    }

    public String getPotencia() {
        return this.potencia;
    }

    public String getCilindrada() {
        return this.cilindrada;
    }

    public String getPesoLiquido() {
        return this.pesoLiquido;
    }

    public String getPesoBruto() {
        return this.pesoBruto;
    }

    public String getNumeroSerie() {
        return this.numeroSerie;
    }

    public NFNotaInfoCombustivelTipo getTipoCombustivel() {
        return this.tipoCombustivel;
    }

    public String getNumeroMotor() {
        return this.numeroMotor;
    }

    public String getCapacidadeMaximaTracao() {
        return this.capacidadeMaximaTracao;
    }

    public String getDistanciaEntreEixos() {
        return this.distanciaEntreEixos;
    }

    public Integer getAnoModeloFabricacao() {
        return this.anoModeloFabricacao;
    }

    public Integer getAnoFabricacao() {
        return this.anoFabricacao;
    }

    public String getTipoPintura() {
        return this.tipoPintura;
    }

    public NFNotaInfoTipoVeiculo getTipoVeiculo() {
        return this.tipoVeiculo;
    }

    public NFNotaInfoEspecieVeiculo getEspecieVeiculo() {
        return this.especieVeiculo;
    }

    public NFNotaInfoItemProdutoVeiculoCondicaoChassi getCondicaoChassi() {
        return this.condicaoChassi;
    }

    public NFNotaInfoItemProdutoVeiculoCondicao getCondicao() {
        return this.condicao;
    }

    public String getCodigoMarcaModelo() {
        return this.codigoMarcaModelo;
    }

    public NFNotaInfoVeiculoCor getCorDENATRAN() {
        return this.corDENATRAN;
    }

    public Integer getLotacao() {
        return this.lotacao;
    }

    public NFNotaInfoItemProdutoVeiculoRestricao getRestricao() {
        return this.restricao;
    }
}

