/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe310.classes.evento.manifestacaodestinatario.NFEnviaEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe310.classes.evento.manifestacaodestinatario.NFEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe310.classes.evento.manifestacaodestinatario.NFInfoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe310.classes.evento.manifestacaodestinatario.NFInfoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe310.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe310.parsers.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.RecepcaoEventoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

public class WSManifestacaoDestinatario
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private final NFeConfig config;

    public WSManifestacaoDestinatario(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFEnviaEventoRetorno manifestaDestinatarioNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaManifestacaoDestinatario(string2, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    NFEnviaEventoRetorno manifestaDestinatarioNota(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosManifestacaoDestinatario(string, nFTipoEventoManifestacaoDestinatario, string2, string3).toString();
        String string5 = new DFAssinaturaDigital(this.config).assinarDocumento(string4);
        OMElement oMElement = this.efetuaManifestacaoDestinatario(string5, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    private OMElement efetuaManifestacaoDestinatario(String string, String string2) throws Exception {
        RecepcaoEventoStub.NfeCabecMsg nfeCabecMsg = new RecepcaoEventoStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(VERSAO_LEIAUTE.toPlainString());
        RecepcaoEventoStub.NfeCabecMsgE nfeCabecMsgE = new RecepcaoEventoStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        RecepcaoEventoStub.NfeDadosMsg nfeDadosMsg = new RecepcaoEventoStub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string2);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfChaveAcesso(string2);
        String string3 = nFAutorizador31.getRecepcaoEventoAN(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador31.name());
        }
        RecepcaoEventoStub.NfeRecepcaoEventoResult nfeRecepcaoEventoResult = new RecepcaoEventoStub(string3, this.config).nfeRecepcaoEvento(nfeDadosMsg, nfeCabecMsgE);
        OMElement oMElement2 = nfeRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private NFEnviaEventoManifestacaoDestinatario gerarDadosManifestacaoDestinatario(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) {
        NFInfoManifestacaoDestinatario nFInfoManifestacaoDestinatario = new NFInfoManifestacaoDestinatario();
        nFInfoManifestacaoDestinatario.setDescricaoEvento(nFTipoEventoManifestacaoDestinatario.getDescricao());
        nFInfoManifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        nFInfoManifestacaoDestinatario.setJustificativa(string2);
        NFInfoEventoManifestacaoDestinatario nFInfoEventoManifestacaoDestinatario = new NFInfoEventoManifestacaoDestinatario();
        nFInfoEventoManifestacaoDestinatario.setAmbiente(this.config.getAmbiente());
        nFInfoEventoManifestacaoDestinatario.setChave(string);
        nFInfoEventoManifestacaoDestinatario.setCnpj(string3);
        nFInfoEventoManifestacaoDestinatario.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        nFInfoEventoManifestacaoDestinatario.setId(String.format("ID%s%s0%s", nFTipoEventoManifestacaoDestinatario.getCodigo(), string, "1"));
        nFInfoEventoManifestacaoDestinatario.setNumeroSequencialEvento(1);
        nFInfoEventoManifestacaoDestinatario.setOrgao(DFUnidadeFederativa.RFB);
        nFInfoEventoManifestacaoDestinatario.setCodigoEvento(nFTipoEventoManifestacaoDestinatario.getCodigo());
        nFInfoEventoManifestacaoDestinatario.setVersaoEvento(VERSAO_LEIAUTE);
        nFInfoEventoManifestacaoDestinatario.setManifestacaoDestinatario(nFInfoManifestacaoDestinatario);
        NFEventoManifestacaoDestinatario nFEventoManifestacaoDestinatario = new NFEventoManifestacaoDestinatario();
        nFEventoManifestacaoDestinatario.setInfoEvento(nFInfoEventoManifestacaoDestinatario);
        nFEventoManifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoManifestacaoDestinatario nFEnviaEventoManifestacaoDestinatario = new NFEnviaEventoManifestacaoDestinatario();
        nFEnviaEventoManifestacaoDestinatario.setEvento(Collections.singletonList(nFEventoManifestacaoDestinatario));
        nFEnviaEventoManifestacaoDestinatario.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        nFEnviaEventoManifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        return nFEnviaEventoManifestacaoDestinatario;
    }
}

