/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.nota.consulta.NFNotaConsulta;
import com.fincatto.documentofiscal.nfe310.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe310.parsers.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.NfeConsulta2Stub;
import com.fincatto.documentofiscal.nfe310.webservices.nota.consulta.NfeConsultaStub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "3.10";
    private final NFeConfig config;

    WSNotaConsulta(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFNotaConsultaRetorno consultaNota(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, string);
        this.getLogger().debug(oMElement2.toString());
        return (NFNotaConsultaRetorno)this.config.getPersister().read(NFNotaConsultaRetorno.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(OMElement oMElement, String string) throws Exception {
        boolean bl;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        boolean bl2 = bl = DFUnidadeFederativa.BA.equals((Object)notaFiscalChaveParser.getNFUnidadeFederativa()) && DFModelo.NFE.equals((Object)notaFiscalChaveParser.getModelo());
        if (bl) {
            return this.efetuaConsultaBA(oMElement, string);
        }
        return this.efetuaConsultaSVRS(oMElement, string);
    }

    private OMElement efetuaConsultaSVRS(OMElement oMElement, String string) throws RemoteException {
        String string2;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        NfeConsulta2Stub.NfeCabecMsg nfeCabecMsg = new NfeConsulta2Stub.NfeCabecMsg();
        nfeCabecMsg.setCUF(notaFiscalChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(VERSAO_SERVICO);
        NfeConsulta2Stub.NfeCabecMsgE nfeCabecMsgE = new NfeConsulta2Stub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        NfeConsulta2Stub.NfeDadosMsg nfeDadosMsg = new NfeConsulta2Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfChaveAcesso(string);
        String string3 = string2 = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? nFAutorizador31.getNfceConsultaProtocolo(this.config.getAmbiente()) : nFAutorizador31.getNfeConsultaProtocolo(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para ConsultaProtocolo " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador31.name());
        }
        NfeConsulta2Stub.NfeConsultaNF2Result nfeConsultaNF2Result = new NfeConsulta2Stub(string2, this.config).nfeConsultaNF2(nfeDadosMsg, nfeCabecMsgE);
        return nfeConsultaNF2Result.getExtraElement();
    }

    private OMElement efetuaConsultaBA(OMElement oMElement, String string) throws RemoteException {
        String string2;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        NfeConsultaStub.NfeCabecMsg nfeCabecMsg = new NfeConsultaStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(notaFiscalChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(VERSAO_SERVICO);
        NfeConsultaStub.NfeCabecMsgE nfeCabecMsgE = new NfeConsultaStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        NfeConsultaStub.NfeDadosMsg nfeDadosMsg = new NfeConsultaStub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfChaveAcesso(string);
        String string3 = string2 = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? nFAutorizador31.getNfceConsultaProtocolo(this.config.getAmbiente()) : nFAutorizador31.getNfeConsultaProtocolo(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para ConsultaProtocolo " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador31.name());
        }
        NfeConsultaStub.NfeConsultaNFResult nfeConsultaNFResult = new NfeConsultaStub(string2, this.config).nfeConsultaNF(nfeDadosMsg, nfeCabecMsgE);
        return nfeConsultaNFResult.getExtraElement();
    }

    private NFNotaConsulta gerarDadosConsulta(String string) {
        NFNotaConsulta nFNotaConsulta = new NFNotaConsulta();
        nFNotaConsulta.setAmbiente(this.config.getAmbiente());
        nFNotaConsulta.setChave(string);
        nFNotaConsulta.setServico(NOME_SERVICO);
        nFNotaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return nFNotaConsulta;
    }
}

