/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento.averbacaoexportacao;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.evento.averbacaoexportacao.NFInfoAverbacaoExportacao;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class NFInfoEventoAverbacaoExportacao
extends DFBase {
    private static final long serialVersionUID = 2460706933290434169L;
    @Attribute(name="Id")
    private String id;
    @Element(name="cOrgao")
    private DFUnidadeFederativa orgao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="chNFe")
    private String chave;
    @Element(name="dhEvento")
    private ZonedDateTime dataHoraEvento;
    @Element(name="tpEvento")
    private String codigoEvento;
    @Element(name="nSeqEvento")
    private Integer numeroSequencialEvento;
    @Element(name="verEvento")
    private String versaoEvento;
    @Element(name="detEvento")
    private NFInfoAverbacaoExportacao averbacaoExportacao;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        DFStringValidador.exatamente54(string, "Info Evento Averbacao Exportacao ID");
        this.id = string;
    }

    public DFUnidadeFederativa getOrgao() {
        return this.orgao;
    }

    public void setOrgao(DFUnidadeFederativa dFUnidadeFederativa) {
        this.orgao = dFUnidadeFederativa;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        DFStringValidador.exatamente44N(string, "Info Evento Averbacao Exportacao Chave");
        this.chave = string;
    }

    public ZonedDateTime getDataHoraEvento() {
        return this.dataHoraEvento;
    }

    public void setDataHoraEvento(ZonedDateTime zonedDateTime) {
        this.dataHoraEvento = zonedDateTime;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String string) {
        DFStringValidador.exatamente6N(string, "Info Evento Averbacao Exportacao Codigo");
        this.codigoEvento = string;
    }

    public int getNumeroSequencialEvento() {
        return this.numeroSequencialEvento;
    }

    public void setNumeroSequencialEvento(int n) {
        DFIntegerValidador.tamanho1a2(n, "Numero Sequencial Evento");
        this.numeroSequencialEvento = n;
    }

    public String getVersaoEvento() {
        return this.versaoEvento;
    }

    public void setVersaoEvento(BigDecimal bigDecimal) {
        this.versaoEvento = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao do Evento");
    }

    public NFInfoAverbacaoExportacao getAverbacaoExportacao() {
        return this.averbacaoExportacao;
    }

    public void setAverbacaoExportacao(NFInfoAverbacaoExportacao nFInfoAverbacaoExportacao) {
        this.averbacaoExportacao = nFInfoAverbacaoExportacao;
    }
}

