/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="envEvento")
@Namespace(reference="http://www.portalfiscal.inf.br/nfe")
public class NFEnviaEventoCancelamento
extends DFBase {
    private static final long serialVersionUID = 2370103749912669480L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="idLote")
    private String idLote;
    @ElementList(entry="evento", inline=true)
    private List<NFEventoCancelamento> evento;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao");
    }

    public String getVersao() {
        return this.versao;
    }

    public String getIdLote() {
        return this.idLote;
    }

    public void setIdLote(String string) {
        DFStringValidador.tamanho15N(string, "ID do Lote");
        this.idLote = string;
    }

    public List<NFEventoCancelamento> getEvento() {
        return this.evento;
    }

    public void setEvento(List<NFEventoCancelamento> list) {
        DFListValidador.tamanho20(list, "Evento de Cancelamento");
        this.evento = list;
    }
}

