/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento.epec;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEventoEpec;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFListValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="envEvento")
@Namespace(reference="http://www.portalfiscal.inf.br/nfe")
public class NFEnviaEventoEpec
extends DFBase {
    @Attribute(name="versao", required=true)
    private String versao;
    @Element(name="idLote", required=true)
    private String idLote;
    @ElementList(entry="evento", inline=true, required=true)
    private List<NFEventoEpec> evento;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao");
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String string) {
        this.versao = string;
    }

    public String getIdLote() {
        return this.idLote;
    }

    public void setIdLote(String string) {
        DFStringValidador.tamanho15N(string, "ID do Lote");
        this.idLote = string;
    }

    public List<NFEventoEpec> getEvento() {
        return this.evento;
    }

    public void setEvento(List<NFEventoEpec> list) {
        DFListValidador.tamanho20(list, "Evento de Conting\u00eancia EPEC");
        this.evento = list;
    }
}

