/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.NFIndicadorFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFMeioPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;

public class NFNotaInfoFormaPagamento
extends DFBase {
    private static final long serialVersionUID = 8908558834476720280L;
    @Element(name="indPag", required=false)
    private NFIndicadorFormaPagamento indicadorFormaPagamento;
    @Element(name="tPag")
    private NFMeioPagamento meioPagamento;
    @Element(name="xPag", required=false)
    private String descricaoMeioPagamento;
    @Element(name="vPag")
    private String valorPagamento;
    @Element(name="dPag", required=false)
    private LocalDate dataPagamento;
    @Element(name="CNPJPag", required=false)
    private String cnpjTransacionalPagamento;
    @Element(name="UFPag", required=false)
    private String ufTransacionalPagamento;
    @Element(name="card", required=false)
    private NFNotaInfoCartao cartao;

    public NFNotaInfoFormaPagamento setCartao(NFNotaInfoCartao nFNotaInfoCartao) {
        this.cartao = nFNotaInfoCartao;
        return this;
    }

    public NFNotaInfoCartao getCartao() {
        return this.cartao;
    }

    public NFNotaInfoFormaPagamento setIndicadorFormaPagamento(NFIndicadorFormaPagamento nFIndicadorFormaPagamento) {
        this.indicadorFormaPagamento = nFIndicadorFormaPagamento;
        return this;
    }

    public NFNotaInfoFormaPagamento setMeioPagamento(NFMeioPagamento nFMeioPagamento) {
        this.meioPagamento = nFMeioPagamento;
        return this;
    }

    public NFNotaInfoFormaPagamento setValorPagamento(BigDecimal bigDecimal) {
        this.valorPagamento = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Pagamento");
        return this;
    }

    public NFNotaInfoFormaPagamento setDataPagamento(LocalDate localDate) {
        this.dataPagamento = localDate;
        return this;
    }

    public NFNotaInfoFormaPagamento setCnpjTransacionalPagamento(String string) {
        this.cnpjTransacionalPagamento = string;
        return this;
    }

    public NFNotaInfoFormaPagamento setUfTransacionalPagamento(DFUnidadeFederativa dFUnidadeFederativa) {
        this.ufTransacionalPagamento = dFUnidadeFederativa.getCodigo();
        return this;
    }

    public NFIndicadorFormaPagamento getIndicadorFormaPagamento() {
        return this.indicadorFormaPagamento;
    }

    public NFMeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public String getValorPagamento() {
        return this.valorPagamento;
    }

    public String getDescricaoMeioPagamento() {
        return this.descricaoMeioPagamento;
    }

    public NFNotaInfoFormaPagamento setDescricaoMeioPagamento(String string) {
        DFStringValidador.tamanho2ate60(string, "Descricao Meio Pagamento");
        this.descricaoMeioPagamento = string;
        return this;
    }

    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    public String getCnpjTransacionalPagamento() {
        return this.cnpjTransacionalPagamento;
    }

    public String getUfTransacionalPagamento() {
        return this.ufTransacionalPagamento;
    }
}

