/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFImpostoDevolvido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDFeReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImposto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemObservacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProduto;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class NFNotaInfoItem
extends DFBase {
    private static final long serialVersionUID = 362646693945373643L;
    @Attribute(name="nItem")
    private Integer numeroItem;
    @Element(name="prod")
    private NFNotaInfoItemProduto produto;
    @Element(name="imposto")
    private NFNotaInfoItemImposto imposto;
    @Element(name="impostoDevol", required=false)
    private NFImpostoDevolvido impostoDevolvido;
    @Element(name="infAdProd", required=false)
    private String informacoesAdicionais;
    @Element(name="obsItem", required=false)
    private NFNotaInfoItemObservacao itemObservacao;
    @Element(name="vItem", required=false)
    private String vItem;
    @Element(name="DFeReferenciado", required=false)
    private NFNotaInfoDFeReferenciado dfeReferenciado;

    public void setNumeroItem(Integer n) {
        DFIntegerValidador.tamanho3maximo990(n, "Numero do Item");
        this.numeroItem = n;
    }

    public void setInformacoesAdicionais(String string) {
        DFStringValidador.tamanho500(string, "Informacoes Adicionais do Item");
        this.informacoesAdicionais = string;
    }

    public void setProduto(NFNotaInfoItemProduto nFNotaInfoItemProduto) {
        this.produto = nFNotaInfoItemProduto;
    }

    public void setImposto(NFNotaInfoItemImposto nFNotaInfoItemImposto) {
        this.imposto = nFNotaInfoItemImposto;
    }

    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    public NFNotaInfoItemProduto getProduto() {
        return this.produto;
    }

    public NFNotaInfoItemImposto getImposto() {
        return this.imposto;
    }

    public String getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public NFImpostoDevolvido getImpostoDevolvido() {
        return this.impostoDevolvido;
    }

    public void setImpostoDevolvido(NFImpostoDevolvido nFImpostoDevolvido) {
        this.impostoDevolvido = nFImpostoDevolvido;
    }

    public NFNotaInfoItemObservacao getItemObservacao() {
        return this.itemObservacao;
    }

    public void setItemObservacao(NFNotaInfoItemObservacao nFNotaInfoItemObservacao) {
        this.itemObservacao = nFNotaInfoItemObservacao;
    }

    public String getVItem() {
        return this.vItem;
    }

    public void setVItem(BigDecimal bigDecimal) {
        this.vItem = DFBigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor do Item do DFe Referenciado");
    }

    public NFNotaInfoDFeReferenciado getDFeReferenciado() {
        return this.dfeReferenciado;
    }

    public void setDFeReferenciado(NFNotaInfoDFeReferenciado nFNotaInfoDFeReferenciado) {
        this.dfeReferenciado = nFNotaInfoDFeReferenciado;
    }
}

