/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSST
extends DFBase {
    private static final long serialVersionUID = -2354449482492846488L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="vBCSTRet")
    private String valorBCICMSSTRetidoUFRemetente;
    @Element(name="pST", required=false)
    private String aliqSuportadaConsFinal;
    @Element(name="vICMSSubstituto", required=false)
    private String valorICMSSubstituto;
    @Element(name="vICMSSTRet")
    private String valorICMSSTRetidoUFRemetente;
    @Element(name="vBCFCPSTRet", required=false)
    private String valorBCFundoCombatePobrezaRetidoST;
    @Element(name="pFCPSTRet", required=false)
    private String percentualFundoCombatePobrezaRetidoST;
    @Element(name="vFCPSTRet", required=false)
    private String valorFundoCombatePobrezaRetidoST;
    @Element(name="vBCSTDest")
    private String valorBCICMSSTUFDestino;
    @Element(name="vICMSSTDest")
    private String valorICMSSTUFDestino;
    @Element(name="pRedBCEfet", required=false)
    private String percentualReducaoBCEfetiva;
    @Element(name="vBCEfet", required=false)
    private String valorBCEfetiva;
    @Element(name="pICMSEfet", required=false)
    private String percentualAliquotaICMSEfetiva;
    @Element(name="vICMSEfet", required=false)
    private String valorICMSEfetivo;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setValorBCICMSSTRetidoUFRemetente(BigDecimal bigDecimal) {
        this.valorBCICMSSTRetidoUFRemetente = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST Retido UF Remetente");
    }

    public void setAliqSuportadaConsFinal(BigDecimal bigDecimal) {
        this.aliqSuportadaConsFinal = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Al\u00edquota suportada pelo Consumidor Final");
    }

    public void setValorICMSSubstituto(BigDecimal bigDecimal) {
        this.valorICMSSubstituto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor do ICMS pr\u00f3prio do Substituto");
    }

    public void setValorICMSSTRetidoUFRemetente(BigDecimal bigDecimal) {
        this.valorICMSSTRetidoUFRemetente = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST Retido UF Remetente");
    }

    public void setValorBCFundoCombatePobrezaRetidoST(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobrezaRetidoST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Base de C\u00e1lculo do FCP retido anteriormente");
    }

    public void setPercentualFundoCombatePobrezaRetidoST(BigDecimal bigDecimal) {
        if (bigDecimal.signum() < 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobrezaRetidoST = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza retido ST");
    }

    public void setValorFundoCombatePobrezaRetidoST(BigDecimal bigDecimal) {
        this.valorFundoCombatePobrezaRetidoST = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza retido ST");
    }

    public void setValorBCICMSSTUFDestino(BigDecimal bigDecimal) {
        this.valorBCICMSSTUFDestino = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST UF Destino");
    }

    public void setValorICMSSTUFDestino(BigDecimal bigDecimal) {
        this.valorICMSSTUFDestino = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST UF Destino");
    }

    public void setPercentualReducaoBCEfetiva(BigDecimal bigDecimal) {
        this.percentualReducaoBCEfetiva = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual de redu\u00e7\u00e3o da base de c\u00e1lculo efetiva");
    }

    public void setValorBCEfetiva(BigDecimal bigDecimal) {
        this.valorBCEfetiva = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da base de c\u00e1lculo efetiva");
    }

    public void setPercentualAliquotaICMSEfetiva(BigDecimal bigDecimal) {
        this.percentualAliquotaICMSEfetiva = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual aliquota ICMS efetiva");
    }

    public void setValorICMSEfetivo(BigDecimal bigDecimal) {
        this.valorICMSEfetivo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS efetivo");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getValorBCICMSSTRetidoUFRemetente() {
        return this.valorBCICMSSTRetidoUFRemetente;
    }

    public String getAliqSuportadaConsFinal() {
        return this.aliqSuportadaConsFinal;
    }

    public String getValorICMSSubstituto() {
        return this.valorICMSSubstituto;
    }

    public String getValorICMSSTRetidoUFRemetente() {
        return this.valorICMSSTRetidoUFRemetente;
    }

    public String getValorBCFundoCombatePobrezaRetidoST() {
        return this.valorBCFundoCombatePobrezaRetidoST;
    }

    public String getPercentualFundoCombatePobrezaRetidoST() {
        return this.percentualFundoCombatePobrezaRetidoST;
    }

    public String getValorFundoCombatePobrezaRetidoST() {
        return this.valorFundoCombatePobrezaRetidoST;
    }

    public String getValorBCICMSSTUFDestino() {
        return this.valorBCICMSSTUFDestino;
    }

    public String getValorICMSSTUFDestino() {
        return this.valorICMSSTUFDestino;
    }

    public String getPercentualReducaoBCEfetiva() {
        return this.percentualReducaoBCEfetiva;
    }

    public String getValorBCEfetiva() {
        return this.valorBCEfetiva;
    }

    public String getPercentualAliquotaICMSEfetiva() {
        return this.percentualAliquotaICMSEfetiva;
    }

    public String getValorICMSEfetivo() {
        return this.valorICMSEfetivo;
    }
}

