/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoPISOutrasOperacoes
extends DFBase {
    private static final long serialVersionUID = 5707508769646733720L;
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaPIS situacaoTributaria;
    @Element(name="vBC", required=false)
    private String valorBaseCalculo;
    @Element(name="pPIS", required=false)
    private String percentualAliquota;
    @Element(name="qBCProd", required=false)
    private String quantidadeVendida;
    @Element(name="vAliqProd", required=false)
    private String valorAliquota;
    @Element(name="vPIS")
    private String valorTributo;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS nFNotaInfoSituacaoTributariaPIS) {
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaPIS;
    }

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        if (this.valorAliquota != null || this.quantidadeVendida != null) {
            throw new IllegalStateException("Nao pode setar percentual aliquota caso valor aliquota ou quantidade vendida esteja setado");
        }
        this.valorBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC PIS OA Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        if (this.valorAliquota != null || this.quantidadeVendida != null) {
            throw new IllegalStateException("Nao pode setar percentual aliquota caso valor aliquota ou quantidade vendida esteja setado");
        }
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota PIS OA Item");
    }

    public void setQuantidadeVendida(BigDecimal bigDecimal) {
        if (this.percentualAliquota != null || this.valorBaseCalculo != null) {
            throw new IllegalStateException("Nao pode setar valor aliquota caso percentual aliquota ou valor base calculo esteja setado");
        }
        this.quantidadeVendida = DFBigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Qtde Vendida PIS OA Item");
    }

    public void setValorAliquota(BigDecimal bigDecimal) {
        if (this.percentualAliquota != null || this.valorBaseCalculo != null) {
            throw new IllegalStateException("Nao pode setar valor aliquota caso percentual aliquota ou valor base calculo esteja setado");
        }
        this.valorAliquota = DFBigDecimalValidador.tamanho15Com4CasasDecimais(bigDecimal, "Valor Aliquota PIS OA Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo PIS OA Item");
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getQuantidadeVendida() {
        return this.quantidadeVendida;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }

    public NFNotaInfoSituacaoTributariaPIS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }
}

