/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoGrupoCreditoPresumido
extends DFBase {
    private static final long serialVersionUID = 3442235647525896376L;
    @Element(name="cCredPresumido")
    private String codigoBeneficioFiscalCreditoPresumido = null;
    @Element(name="pCredPresumido")
    private String percentualCreditoPresumido = null;
    @Element(name="vCredPresumido")
    private String valorCreditoPresumido = null;

    public String getCodigoBeneficioFiscalCreditoPresumido() {
        return this.codigoBeneficioFiscalCreditoPresumido;
    }

    public NFNotaInfoItemProdutoGrupoCreditoPresumido setCodigoBeneficioFiscalCreditoPresumido(String string) {
        DFStringValidador.validaIntervalo(string, 8, 10, "Codigo de beneficio fiscal de credito presumido");
        this.codigoBeneficioFiscalCreditoPresumido = string;
        return this;
    }

    public String getPercentualCreditoPresumido() {
        return this.percentualCreditoPresumido;
    }

    public NFNotaInfoItemProdutoGrupoCreditoPresumido setPercentualCreditoPresumido(BigDecimal bigDecimal) {
        this.percentualCreditoPresumido = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual de credito presumido");
        return this;
    }

    public String getValorCreditoPresumido() {
        return this.valorCreditoPresumido;
    }

    public NFNotaInfoItemProdutoGrupoCreditoPresumido setValorCreditoPresumido(BigDecimal bigDecimal) {
        this.valorCreditoPresumido = DFBigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor de credito presumido");
        return this;
    }
}

