/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoDetalhamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoDetalhamentoEmbalagem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoRastreabilidade
extends DFBase {
    private static final long serialVersionUID = 4756407184060968887L;
    @Element(name="nLote")
    private String numeroLote;
    @Element(name="qLote")
    private String quantidadeLote;
    @Element(name="dFab")
    private LocalDate dataFabricacao;
    @Element(name="dVal")
    private LocalDate dataValidade;
    @Element(name="cAgreg", required=false)
    private String codigoAgregacao;
    @Element(name="infProdNFF", required=false)
    private NFNotaInfoItemProdutoDetalhamento informacoesProduto;
    @Element(name="infProdEmb", required=false)
    private NFNotaInfoItemProdutoDetalhamentoEmbalagem informacoesProdutoEmbalagem;

    public void setNumeroLote(String string) {
        DFStringValidador.tamanho20(string, "N\u00famero do lote do rastreio do produto");
        this.numeroLote = string;
    }

    public void setQuantidadeLote(BigDecimal bigDecimal) {
        this.quantidadeLote = DFBigDecimalValidador.tamanho11Com3CasasDecimais(bigDecimal, "Quantidade lote rastreio produto");
    }

    public void setDataFabricacao(LocalDate localDate) {
        this.dataFabricacao = localDate;
    }

    public void setDataValidade(LocalDate localDate) {
        this.dataValidade = localDate;
    }

    public void setCodigoAgregacao(String string) {
        DFStringValidador.tamanho20(string, "C\u00f3digo agrega\u00e7\u00e3o rastreio produto");
        this.codigoAgregacao = string;
    }

    public void setInformacoesProduto(NFNotaInfoItemProdutoDetalhamento nFNotaInfoItemProdutoDetalhamento) {
        this.informacoesProduto = nFNotaInfoItemProdutoDetalhamento;
    }

    public void setInformacoesProdutoEmbalagem(NFNotaInfoItemProdutoDetalhamentoEmbalagem nFNotaInfoItemProdutoDetalhamentoEmbalagem) {
        this.informacoesProdutoEmbalagem = nFNotaInfoItemProdutoDetalhamentoEmbalagem;
    }

    public String getNumeroLote() {
        return this.numeroLote;
    }

    public String getQuantidadeLote() {
        return this.quantidadeLote;
    }

    public LocalDate getDataFabricacao() {
        return this.dataFabricacao;
    }

    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    public String getCodigoAgregacao() {
        return this.codigoAgregacao;
    }

    public NFNotaInfoItemProdutoDetalhamento getInformacoesProduto() {
        return this.informacoesProduto;
    }

    public NFNotaInfoItemProdutoDetalhamentoEmbalagem getInformacoesProdutoEmbalagem() {
        return this.informacoesProdutoEmbalagem;
    }
}

