/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFPais;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.converters.NFStringNullToEmptyConverter;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.convert.Convert;

public class NFNotaInfoLocal
extends DFBase {
    private static final long serialVersionUID = -6618642990785758823L;
    @Element(name="CNPJ", required=false)
    @Convert(value=NFStringNullToEmptyConverter.class)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="xNome", required=false)
    private String nome;
    @Element(name="xLgr")
    private String logradouro;
    @Element(name="nro")
    private String numero;
    @Element(name="xCpl", required=false)
    private String complemento;
    @Element(name="xBairro")
    private String bairro;
    @Element(name="cMun")
    private String codigoMunicipio;
    @Element(name="xMun")
    private String nomeMunicipio;
    @Element(name="UF")
    private String uf;
    @Element(name="CEP", required=false)
    private String cep;
    @Element(name="cPais", required=false)
    private DFPais codigoPais;
    @Element(name="xPais", required=false)
    private String descricaoPais;
    @Element(name="fone", required=false)
    private String telefone;
    @Element(name="email", required=false)
    private String email;
    @Element(name="IE", required=false)
    private String inscricaoEstadual;

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao pode setar CNPJ por que o CPF foi setado");
        }
        if (!StringUtils.isBlank((CharSequence)string)) {
            DFStringValidador.cnpj(string);
        }
        this.cnpj = string;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao pode setar CPF por que o CNPJ foi setado");
        }
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public void setLogradouro(String string) {
        DFStringValidador.tamanho60(string, "Logradouro Local");
        this.logradouro = string;
    }

    public void setNumero(String string) {
        DFStringValidador.tamanho60(string, "Numero Local");
        this.numero = string;
    }

    public void setComplemento(String string) {
        DFStringValidador.tamanho60(string, "Complemento Local");
        this.complemento = string;
    }

    public void setBairro(String string) {
        DFStringValidador.tamanho2ate60(string, "Bairro Local");
        this.bairro = string;
    }

    public void setCodigoMunicipio(String string) {
        DFStringValidador.exatamente7(string, "Codigo Municipio Local");
        this.codigoMunicipio = string;
    }

    public void setNomeMunicipio(String string) {
        DFStringValidador.tamanho60(string, "Nome Municipio Local");
        this.nomeMunicipio = string;
    }

    public void setNome(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome do Expedidor/Recebedor");
        this.nome = string;
    }

    public void setCep(String string) {
        DFStringValidador.exatamente8(string, "CEP");
        this.cep = string;
    }

    public void setCodigoPais(String string) {
        DFStringValidador.tamanho2a4(string, "Codigo do pais");
        this.codigoPais = DFPais.valueOfCodigo(string);
    }

    public void setCodigoPais(DFPais dFPais) {
        this.codigoPais = dFPais;
    }

    public void setDescricaoPais(String string) {
        DFStringValidador.tamanho60(string, "Descricao do pais");
        this.descricaoPais = string;
    }

    public void setTelefone(String string) {
        DFStringValidador.telefone(string);
        this.telefone = string;
    }

    public void setEmail(String string) {
        DFStringValidador.tamanho60(string, "Endere\u00e7o de email");
        DFStringValidador.email(string);
        this.email = string;
    }

    public void setInscricaoEstadual(String string) {
        DFStringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getNome() {
        return this.nome;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public String getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public String getUf() {
        return this.uf;
    }

    public String getCep() {
        return this.cep;
    }

    public DFPais getCodigoPais() {
        return this.codigoPais;
    }

    public String getDescricaoPais() {
        return this.descricaoPais;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }
}

