/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dup")
public class NFNotaInfoParcela
extends DFBase {
    private static final long serialVersionUID = 4401957395684813604L;
    @Element(name="nDup", required=false)
    private String numeroParcela;
    @Element(name="dVenc", required=false)
    private LocalDate dataVencimento;
    @Element(name="vDup")
    private String valorParcela;

    public void setNumeroParcela(String string) {
        DFStringValidador.tamanho60(string, "Numero da Parcela");
        this.numeroParcela = string;
    }

    public void setDataVencimento(LocalDate localDate) {
        this.dataVencimento = localDate;
    }

    public void setValorParcela(BigDecimal bigDecimal) {
        this.valorParcela = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Parcela");
    }

    public String getValorParcela() {
        return this.valorParcela;
    }

    public String getNumeroParcela() {
        return this.numeroParcela;
    }

    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }
}

