/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoRetencoesTributos
extends DFBase {
    private static final long serialVersionUID = 8153484835418045075L;
    @Element(name="vRetPIS", required=false)
    private String valorRetidoPIS;
    @Element(name="vRetCOFINS", required=false)
    private String valorRetidoCOFINS;
    @Element(name="vRetCSLL", required=false)
    private String valorRetidoCSLL;
    @Element(name="vBCIRRF", required=false)
    private String baseCalculoIRRF;
    @Element(name="vIRRF", required=false)
    private String valorRetidoIRRF;
    @Element(name="vBCRetPrev", required=false)
    private String baseCalculoRetencaoPrevidenciaSocial;
    @Element(name="vRetPrev", required=false)
    private String valorRetencaoPrevidenciaSocial;

    public void setValorRetidoPIS(BigDecimal bigDecimal) {
        this.valorRetidoPIS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Retido PIS");
    }

    public void setValorRetidoCOFINS(BigDecimal bigDecimal) {
        this.valorRetidoCOFINS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Retido COFINS");
    }

    public void setValorRetidoCSLL(BigDecimal bigDecimal) {
        this.valorRetidoCSLL = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Retido CSLL");
    }

    public void setBaseCalculoIRRF(BigDecimal bigDecimal) {
        this.baseCalculoIRRF = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "BC IRRF Retencao Tributos");
    }

    public void setValorRetidoIRRF(BigDecimal bigDecimal) {
        this.valorRetidoIRRF = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Retido IRRF");
    }

    public void setBaseCalculoRetencaoPrevidenciaSocial(BigDecimal bigDecimal) {
        this.baseCalculoRetencaoPrevidenciaSocial = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "BC Retencao Previdencia Social");
    }

    public void setValorRetencaoPrevidenciaSocial(BigDecimal bigDecimal) {
        this.valorRetencaoPrevidenciaSocial = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Retencao Previdencia Social");
    }

    public String getValorRetidoPIS() {
        return this.valorRetidoPIS;
    }

    public String getValorRetidoCOFINS() {
        return this.valorRetidoCOFINS;
    }

    public String getValorRetidoCSLL() {
        return this.valorRetidoCSLL;
    }

    public String getBaseCalculoIRRF() {
        return this.baseCalculoIRRF;
    }

    public String getValorRetidoIRRF() {
        return this.valorRetidoIRRF;
    }

    public String getBaseCalculoRetencaoPrevidenciaSocial() {
        return this.baseCalculoRetencaoPrevidenciaSocial;
    }

    public String getValorRetencaoPrevidenciaSocial() {
        return this.valorRetencaoPrevidenciaSocial;
    }
}

